/*!\file ThicknessExtrudex
 * \brief: vertical velocity extrusion
 */

#include "./ThicknessExtrudex.h"

#undef __FUNCT__ 
#define __FUNCT__ "ThicknessExtrudex"

#include "../shared/shared.h"
#include "../include/macros.h"
#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"

void ThicknessExtrudex( Vec tg, DataSet* elements,DataSet* nodes, DataSet* loads, DataSet* materials){

	double* tg_serial=NULL;

	/*First, get elements and nodes configured: */
	elements->Configure(elements,loads, nodes, materials);
	nodes->Configure(elements,loads, nodes, materials);

	/*Serialize velcoity: */
	VecToMPISerial(&tg_serial,tg);

	/*Extrude velocity vertically: */
	elements->ThicknessExtrude(tg,tg_serial);

	/*Assemble vector: */
	VecAssemblyBegin(tg);
	VecAssemblyEnd(tg);

	/*Free ressources:*/
	xfree((void**)&tg_serial);

}
