/*
 * CreateConstraintsDiagnosticStokes.c:
 */

#undef __FUNCT__ 
#define __FUNCT__ "CreateConstraintsDiagnosticStokes"

#include "../../DataSet/DataSet.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../objects/objects.h"
#include "../../shared/shared.h"
#include "../Model.h"


void	CreateConstraintsDiagnosticStokes(DataSet** pconstraints, Model* model,ConstDataHandle model_handle){

	int i;
	DataSet* constraints = NULL;
	Spc*    spc  = NULL;

	/*spc intermediary data: */
	int spc_sid;
	int spc_node;
	int spc_dof;
	double spc_value;
	int count;
	
	double* gridonstokes=NULL;


	/*Create constraints: */
	constraints = new DataSet(ConstraintsEnum());

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!model->isstokes)goto cleanup_and_return;

	/*Fetch data: */
	ModelFetchData((void**)&gridonstokes,NULL,NULL,model_handle,"gridonstokes","Matrix","Mat");

	count=0;
	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<model->numberofnodes;i++){
	#ifdef _PARALLEL_
	/*keep only this partition's nodes:*/
	if((model->my_grids[i]==1)){
	#endif

		if ((int)!gridonstokes[i]){
	
			/*This grid will see its vx,vy and vz dofs spc'd to pattyn velocities: */
			spc_sid=count;
			spc_node=i+1;
			spc_dof=1; //we enforce first x translation degree of freedom
			spc_value=0;

			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;

			spc_sid=count;
			spc_node=i+1;
			spc_dof=2; //we enforce first y translation degree of freedom
			spc_value=0;
			
			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;
			
			spc_sid=count;
			spc_node=i+1;
			spc_dof=3; //we enforce first y translation degree of freedom
			spc_value=0;
			
			spc = new Spc(spc_sid,spc_node,spc_dof,spc_value);
			constraints->AddObject(spc);
			count++;

		}

	#ifdef _PARALLEL_
	} //if((my_grids[i]==1))
	#endif
	}

	/*All our datasets are already order by ids. Set presort flag so that later on, when sorting is requested on these 
	 * datasets, it will not be redone: */
	constraints->Presort();

	/*Free data: */
	xfree((void**)&gridonstokes);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}	
