/*!\file:  ElementVector.h
 * \brief container for information needed to plug element vector generated by elements 
 * into the pf global load vector. 
 * This object will hold the element vector on the g-set, the local as well as global 
 * dof lists in the f set
 */ 

#ifndef _ELEMENT_VECTOR_H_
#define _ELEMENT_VECTOR_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
#include "../../toolkits/toolkits.h"
/*}}}*/

class ElementVector{

	public:
	
		int      nrows;
		double*  values;
		bool     pf;
		
		//gset
		int*     gglobaldoflist;

		//fset
		int      fsize;
		int*     flocaldoflist;
		int*     fglobaldoflist;
		
		/*ElementVector constructors, destructors {{{1*/
		ElementVector();
		ElementVector(int gsize,int* gglobaldoflist);
		ElementVector(int gsize,int* flocaldoflist,int* fglobaldoflist,int fsize);
		~ElementVector();
		/*}}}*/
		/*ElementVector specific routines {{{1*/
		void AddValues(double* pe_gg);
		void AddToGlobal(Vec pg, Vec pf);
		/*}}}*/
};
#endif //#ifndef _ELEMENT_VECTOR_H_

