/*!\file ElementVector.cpp
 * \brief: implementation of the ElementVector object, used to plug values from element into global load
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*ElementVector constructors and destructor*/
/*FUNCTION ElementVector::ElementVector(){{{1*/
ElementVector::ElementVector(){

	this->nrows=0;
	this->values=NULL;
	this->fsize=0;
	this->flocaldoflist=NULL;
	this->fglobaldoflist=NULL;

}
/*}}}*/
/*FUNCTION ElementVector::ElementVector(int gsize,int* gglobaldoflist){{{1*/
ElementVector::ElementVector(int gsize,int* in_gglobaldoflist){

	this->nrows=gsize;
	this->pf=false;
	
	/*fill values with 0: */
	this->values=(double*)xcalloc(this->nrows,sizeof(double));
	
	/*dofs: */
	if(this->nrows){
		this->gglobaldoflist=(int*)xmalloc(nrows*sizeof(int));
		memcpy(this->gglobaldoflist,in_gglobaldoflist,nrows*sizeof(int));
	}
	else{
		this->gglobaldoflist=NULL;
	}
	/*not needed: */
	this->flocaldoflist=NULL;
	this->fglobaldoflist=NULL;

}
/*}}}*/
/*FUNCTION ElementVector::ElementVector(int gsize,int* flocaldoflist,int* fglobaldoflist,int fsize){{{1*/
ElementVector::ElementVector(int gsize,int* in_flocaldoflist,int* in_fglobaldoflist,int in_fsize){

	this->nrows=gsize;
	this->pf=true;
	
	/*fill values with 0: */
	this->values=(double*)xcalloc(this->nrows,sizeof(double));
	
	/*dofs: */
	this->fsize=in_fsize;
	if(this->fsize){
		this->flocaldoflist=(int*)xmalloc(fsize*sizeof(int));
		this->fglobaldoflist=(int*)xmalloc(fsize*sizeof(int));
		memcpy(this->flocaldoflist,in_flocaldoflist,fsize*sizeof(int));
		memcpy(this->fglobaldoflist,in_fglobaldoflist,fsize*sizeof(int));
	}
	else{
		this->flocaldoflist=NULL;
		this->fglobaldoflist=NULL;
	}
	
	/*not needed: */
	this->gglobaldoflist=NULL;

}
/*}}}*/
/*FUNCTION ElementVector::~ElementVector(){{{1*/
ElementVector::~ElementVector(){
	
	xfree((void**)&this->values);
	xfree((void**)&this->gglobaldoflist);
	xfree((void**)&this->flocaldoflist);
	xfree((void**)&this->fglobaldoflist);
}
/*}}}*/

/*ElementVector specific routines: */
/*FUNCTION ElementVector::AddValues(double* Ke_gg){{{1*/
void ElementVector::AddValues(double* pe_gg){

	int i,j;

	if(pe_gg){
		for (i=0;i<this->nrows;i++){
			this->values[i]+=pe_gg[i];
		}
	}
}
/*}}}*/
/*FUNCTION ElementVector::AddToGlobal(Vec pg, Vec pf){{{1*/
void ElementVector::AddToGlobal(Vec pg, Vec pf){

	int i;
	double* localvalues=NULL;

	if(!pf){
		/*add local values into global  vector, using the fglobaldoflist: */
		VecSetValues(pg,this->nrows,this->gglobaldoflist,(const double*)values,ADD_VALUES);
	}
	else{
		if(this->fsize){
			/*first, retrieve values that are in the f-set from the g-set values vector: */
			localvalues=(double*)xmalloc(this->fsize*sizeof(double));
			for(i=0;i<this->fsize;i++){
				localvalues[i]=this->values[this->flocaldoflist[i]];
			}
			/*add local values into global  vector, using the fglobaldoflist: */
			VecSetValues(pf,this->fsize,this->fglobaldoflist,(const double*)localvalues,ADD_VALUES);

			/*Free ressources:*/
			xfree((void**)&localvalues);
		}
	}
}
/*}}}*/
