#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#Some cleanup
rm -rf Dakota
rm -rf src src_nomatlab
rm -rf install install_nomatlab

#Create src and install directories
mkdir src src_nomatlab install install_nomatlab

#version of doxygen
version=`echo *.src.tar.gz | sed 's/\.src\.tar\.gz//g' | sed 's/Dakota_//g'`

#Untar 
tar -zxvf  Dakota_$version.src.tar.gz

#Move Dakota to src directory
mv Dakota/* src
rm -rf Dakota
cp -Rf src src_nomatlab

#Apply patches
patch src/src/ParallelLibrary.C ./ParallelLibrary.C.patch
patch src/src/ParallelLibrary.H ./ParallelLibrary.H.patch

patch src_nomatlab/src/ParallelLibrary.C ./ParallelLibrary.C.patch
patch src_nomatlab/src/ParallelLibrary.H ./ParallelLibrary.H.patch

#Configure dakota
cd src
./configure --prefix="$ISSM_DIR/externalpackages/dakota/install" --without-graphics  --with-matlab=$MATLAB_DIR

#Compile dakota
make  -j $NUMCPUS

#Install dakota
make  install

#Configure dakota with no matlab
cd ../src_nomatlab
./configure --prefix="$ISSM_DIR/externalpackages/dakota/install_nomatlab" --without-graphics 

#Compile dakota
make  -j $NUMCPUS

#Install dakota
make  install
