
/*
	OutputDiagnostic.c: output model results for diagnostic solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputDiagnostic"

#include "../toolkits/toolkits.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"

void OutputDiagnostic(Vec u_g,Vec partition,char* filename,NodeSets* nodesets,char* analysis_type){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	/* standard output: */
	double* serial_partition=NULL;
	int    analysis_size;

	double* serial_u_g=NULL;
	int     one=1;
	int     gsize;

	/*serialize outputs: */
	VecShift(partition,1.0); //matlab indexing
	VecToMPISerial(&serial_partition,partition);

	VecToMPISerial(&serial_u_g,u_g);

	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=fopen(filename,"wb");
		if(fid==NULL)throw ErrorException(__FUNCT__,exprintf("%s%s%s","could not open file ",filename," for binary writing."));

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write uset.gsize: */
		gsize=nodesets->GetGSize();
		WriteDataToDisk(&gsize,NULL,NULL,"Integer",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&gsize,&one,"Mat",fid);
		
		/*Write solution to disk: */
		WriteDataToDisk(serial_u_g,&gsize,&one,"Mat",fid);
	
		/*Close file: */
		if(fclose(fid)!=0)throw ErrorException(__FUNCT__,exprintf("%s%s","could not close file ",filename));
	}

}	
