md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'','');
md=parameterize(md,'../Par/SquareSheetConstrained.par');
md=extrude(md,3,1);
md.cluster='none';
md=setelementstype(md,'stokes','all');
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-09,1e-09,1e-09,1e-09,1e-09};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
