/*\file Reduceload.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceload.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Vec         pf         = NULL;
	Mat         Kfs        = NULL;
	Vec         ys         = NULL;
	bool        flag_ys0=false;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=3 && nrhs!=4)){
		ReduceloadUsage();
		ISSMERROR(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&pf,PF);
	FetchData(&Kfs,KFS);
	FetchData(&ys,YS);
	if(nrhs==4)FetchData(&flag_ys0,YSFLAG);
	else flag_ys0=false;

	/*!Reduce load from g to f size: */
	Reduceloadx(pf, Kfs, ys, flag_ys0);

	/*write output datasets: */
	WriteData(PFOUT,pf);

	/*Free ressources: */
	VecFree(&pf);
	MatFree(&Kfs);
	VecFree(&ys);

	/*end module: */
	MODULEEND();
}

void ReduceloadUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [pf] = %s(pf,Kfs,ys);\n",__FUNCT__);
	_printf_("          [pf] = %s(pf,Kfs,ys,ys0_flag);\n",__FUNCT__);
	_printf_("\n");
}
