/*!\file Reducevectorgtosx
 * \brief reduce petsc vector from g set to s set (single point constraints), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtosx.h"

void Reducevectorgtosx( Vec* pys, Vec yg, NodeSets* nodesets,Parameters* parameters){

	/*output: */
	Vec ys=NULL;

	/*what type of partitioning: */
	bool kffpartitioning=false;

	/*find parameter: */
	parameters->FindParam(&kffpartitioning,KffEnum);

	if(nodesets){
		if (nodesets->GetGSize() && nodesets->GetSSize()){
			VecPartition(&ys,yg,nodesets->GetPV_S(),nodesets->GetSSize(),kffpartitioning);
		}
	}
	
	/*Assign output pointer:*/
	*pys=ys;
}
