/*!\file Reducevectorgtofx
 * \brief reduce petsc vector from g set to s set (free dofs), using the nodeset partitioning 
 * vectors.
 */

#include "./Reducevectorgtofx.h"
 
void Reducevectorgtofx(Vec* puf, Vec ug, NodeSets* nodesets,Parameters* parameters){

	/*output: */
	Vec uf=NULL;

	/*what type of partitioning: */
	bool kffpartitioning=false;

	/*find parameter: */
	parameters->FindParam(&kffpartitioning,KffEnum);

	if(nodesets){


		if (nodesets->GetGSize() && nodesets->GetFSize()){

			VecPartition(&uf,ug,nodesets->GetPV_F(),nodesets->GetFSize(),kffpartitioning);
		
		}
	}
	
	/*Assign output pointers:*/
	*puf=uf;
}
