function femmodel=solver_thermal_nonlinear(femmodel)
%SOLVER_THERMAL_NONLINEAR - core of thermal solution sequence.
%   femmodel is returned together with temperature and melting_offset, in case loads have been modified
%
%   Usage:
%      [femmodel]=solver_thermal_nonlinear(femmodel)

	count=1;
	converged=0;

	%stiffness and load generation only:
	femmodel.parameters.Kflag=1; femmodel.parameters.Pflag=1;

	displaystring(femmodel.parameters.Verbose,'\n%s',['   starting direct shooting method']);

	%Reset penalties and initialize convergence as false
	[femmodel.elements loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,0,ConvergedEnum);
	[femmodel.elements femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,1,ResetPenaltiesEnum);

	while(~converged),

		[K_gg,K_ff,K_fs,p_g,p_f,melting_offset]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

		[K_ff, K_fs] = Reducematrixfromgtof( K_gg, femmodel.nodesets,femmodel.parameters); 
		p_f = Reduceloadfromgtof( p_g, K_fs, femmodel.ys, femmodel.nodesets,femmodel.parameters);

		displaystring(femmodel.parameters.Verbose,'%s%g','   condition number of stiffness matrix: ',condest(K_ff));
		t_f=Solver(K_ff,p_f,[],femmodel.parameters);
		t_g= Mergesolutionfromftog( t_f, femmodel.ys, femmodel.nodesets,femmodel.parameters); 

		[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,t_g);
		[femmodel.loads,constraints_converged,num_unstable_constraints] =PenaltyConstraints(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads, femmodel.materials,femmodel.parameters);
	
		if ~converged,
			displaystring(femmodel.parameters.Verbose,'%s%i','   #unstable constraints ',num_unstable_constraints);
			if num_unstable_constraints<=femmodel.parameters.MinThermalConstraints,
				converged=1;
			end
		end
		[femmodel.elements loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,double(converged),ConvergedEnum);
		count=count+1;
	end

	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,t_g);
	[femmodel.elements femmodel.loads]=InputUpdateFromConstant(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,melting_offset,MeltingOffsetEnum);
end
