/*!\file:  ElementMatrix.h
 * \brief container for information needed to plug element matrix generated by elements 
 * into the Kff and Kfs global matrices. 
 * This object will hold the element matrix on the g-set, the internal as well as external 
 * dof lists in the f and s sets.
 */ 

#ifndef _ELEMENT_MATRIX_H_
#define _ELEMENT_MATRIX_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
#include "../../toolkits/toolkits.h"
/*}}}*/

class ElementMatrix{

	public:
	
		int      nrows;
		int      ncols;
		double*  values;
		bool     symmetric;
		bool     kff;

		//gset
		int*     gexternaldoflist;

		/*row wise: */
		//fset
		int      row_fsize;
		int*     row_finternaldoflist;
		int*     row_fexternaldoflist;
		//sset
		int      row_ssize;
		int*     row_sinternaldoflist;
		int*     row_sexternaldoflist;

		/*column wise: */
		//fset
		int      col_fsize;
		int*     col_finternaldoflist;
		int*     col_fexternaldoflist;
		//sset
		int      col_ssize;
		int*     col_sinternaldoflist;
		int*     col_sexternaldoflist;

		/*ElementMatrix constructors, destructors {{{1*/
		ElementMatrix();
		ElementMatrix(int gsize,bool symmetric,int* gexternaldoflist);
		ElementMatrix(int gsize,bool symmetric,int* finternaldoflist,int* fexternaldoflist,int fsize,int* sinternaldoflist,int* sexternaldoflist,int ssize);
		~ElementMatrix();
		/*}}}*/
		/*ElementMatrix specific routines {{{1*/
		void AddValues(double* Ke_gg);
		void AddToGlobal(Mat Kgg, Mat Kff, Mat Kfs);
		void Echo(void);
		/*}}}*/
};
#endif //#ifndef _ELEMENT_MATRIX_H_

