/*! \file Tria.h 
 *  \brief: header file for tria object
 */

#ifndef _TRIA_H_
#define _TRIA_H_

/*Headers:*/
/*{{{1*/
#include "./Element.h"
#include "./TriaHook.h"
#include "./TriaRef.h"
class Parameters;
class Inputs;
class IoModel;
class Node;
class Matice;
class Matpar;
class ElementMatrix;
class ElementVector;

#include "../../include/include.h"
#include "../../shared/Exceptions/exceptions.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
/*}}}*/

class Tria: public Element,public TriaHook,public TriaRef{

	public:

		int  id;

		Node   **nodes;    // 3 nodes
		Matice  *matice;   // 1 material ice
		Matpar  *matpar;   // 1 material parameter

		Parameters *parameters;   //pointer to solution parameters
		Inputs     *inputs;
		Results    *results;

		/*Tria constructors, destructors {{{1*/
		Tria();
		Tria(int tria_id,int i, IoModel* iomodel,int nummodels);
		~Tria();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromSolution(double* solutiong);
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		/*}}}*/
		/*Element virtual functions definitions: {{{1*/
		void   AverageOntoPartition(Vec partition_contributions,Vec partition_areas,double* vertex_response,double* qmu_part);
		void   ComputeBasalStress(Vec sigma_b);
		void   ComputeStrainRate(Vec eps);
		void   Configure(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		void   SetCurrentConfiguration(Elements* elements,Loads* loads,DataSet* nodes,Materials* materials,Parameters* parameters);
		double RegularizeInversion(void);
		void   CreateKMatrix(Mat Kgg, Mat Kff, Mat Kfs);
		void   CreatePVector(Vec pg, Vec pf);
		int    GetNodeIndex(Node* node);
		bool   IsOnBed();
		bool   IsOnShelf(); 
		bool   IsOnWater(); 
		void   GetSolutionFromInputs(Vec solution);
		void   GetVectorFromInputs(Vec vector,int NameEnum);
		void   Gradj(Vec gradient,int control_type);
		void   GradjB(Vec gradient);
		void   GradjDrag(Vec gradient);
		void   GradjDhDt(Vec gradient);
		void   InputControlUpdate(double scalar,bool save_parameter);
		void   InputArtificialNoise(int enum_type,double min, double max);
		bool   InputConvergence(double* eps, int* enums,int num_enums,int* criterionenums,double* criterionvalues,int num_criterionenums);
		void   InputDepthAverageAtBase(int enum_type,int average_enum_type,int object_enum=ElementsEnum);
		void   InputDuplicate(int original_enum,int new_enum);
		void   InputScale(int enum_type,double scale_factor);
		void   InputToResult(int enum_type,int step,double time);
		void   DeleteResults(void);
		void   MaterialUpdateFromTemperature(void){ISSMERROR("not implemented yet");};
		double MassFlux(double* segment,bool process_units);
		void   MaxAbsVx(double* pmaxabsvx, bool process_units);
		void   MaxAbsVy(double* pmaxabsvy, bool process_units);
		void   MaxAbsVz(double* pmaxabsvz, bool process_units);
		void   MaxVel(double* pmaxvel, bool process_units);
		void   MaxVx(double* pmaxvx, bool process_units);
		void   MaxVy(double* pmaxvy, bool process_units);
		void   MaxVz(double* pmaxvz, bool process_units);
		void   MinVel(double* pminvel, bool process_units);
		void   MinVx(double* pminvx, bool process_units);
		void   MinVy(double* pminvy, bool process_units);
		void   MinVz(double* pminvz, bool process_units);
		double ThicknessAbsMisfit(bool process_units);
		double SurfaceAbsVelMisfit(bool process_units);
		double SurfaceRelVelMisfit(bool process_units);
		double SurfaceLogVelMisfit(bool process_units);
		double SurfaceLogVxVyMisfit(bool process_units);
		double SurfaceAverageVelMisfit(bool process_units);
		void   PatchFill(int* pcount, Patch* patch);
		void   PatchSize(int* pnumrows, int* pnumvertices,int* pnumnodes);
		void   ProcessResultsUnits(void);
		double SurfaceArea(void);
		void   Update(int index, IoModel* iomodel,int analysis_counter,int analysis_type);
		void   UpdateGeometry(void);
		/*}}}*/
		/*Tria specific routines:{{{1*/
		void	  CreateKMatrixBalancedthickness_DG(Mat Kgg);
		void	  CreateKMatrixBalancedthickness_CG(Mat Kgg);
		void	  CreateKMatrixBalancedvelocities(Mat Kgg);
		void	  CreateKMatrixDiagnosticMacAyeal(Mat Kgg,Mat Kff, Mat Kfs);
		double*   CreateKMatrixDiagnosticMacAyealViscous(void);
		double*   CreateKMatrixDiagnosticMacAyealFriction(void);
		void      CreateKMatrixDiagnosticMacAyealFriction(Mat Kgg,Mat Kff, Mat Kfs);
		void	  CreateKMatrixCouplingMacAyealPattynFriction(Mat Kgg);
		void	  CreateKMatrixDiagnosticPattynFriction(Mat Kgg);
		void	  CreateKMatrixDiagnosticHutter(Mat Kgg);
		void	  CreateKMatrixDiagnosticSurfaceVert(Mat Kgg);
		void	  CreateKMatrixMelting(Mat Kgg);
		void	  CreateKMatrixPrognostic_CG(Mat Kgg);
		void	  CreateKMatrixPrognostic_DG(Mat Kgg);
		void	  CreateKMatrixSlope(Mat Kgg);
		void	  CreateKMatrixThermal(Mat Kgg);
		void	  CreatePVectorBalancedthickness_DG(Vec pg);
		void	  CreatePVectorBalancedthickness_CG(Vec pg);
		void	  CreatePVectorBalancedvelocities(Vec pg);
		void	  CreatePVectorDiagnosticBaseVert(Vec pg);
		void	  CreatePVectorDiagnosticMacAyeal(Vec pg);
		void	  CreatePVectorAdjointHoriz(Vec pg);
		void	  CreatePVectorAdjointStokes(Vec pg);
		void	  CreatePVectorAdjointBalancedthickness(Vec pg);
		void	  CreatePVectorDiagnosticHutter(Vec pg);
		void	  CreatePVectorPrognostic_CG(Vec pg);
		void	  CreatePVectorPrognostic_DG(Vec pg);
		void	  CreatePVectorSlope( Vec pg);
		void	  CreatePVectorThermalSheet( Vec pg);
		void	  CreatePVectorThermalShelf( Vec pg);
		double    GetArea(void);
		int       GetElementType(void);
		void	  GetDofList(int** pdoflist,int approximation_enum,int setenum);
		void	  GetDofList1(int* doflist);
		int*      GetInternalDofList(int approximation_enum,int setenum);
		int*      GetExternalDofList(int approximation_enum,int setenum);
		int       GetNumberOfDofs(int approximation_enum,int setenum);
		void      GetParameterListOnVertices(double* pvalue,int enumtype);
		void      GetParameterListOnVertices(double* pvalue,int enumtype,double defaultvalue);
		void      GetParameterValue(double* pvalue,Node* node,int enumtype);
		void	  GetSolutionFromInputsDiagnosticHoriz(Vec solution);
		void	  GetSolutionFromInputsDiagnosticHutter(Vec solution);
		void      GetStrainRate2d(double* epsilon,double* xyz_list, GaussTria* gauss, Input* vx_input, Input* vy_input);
		void	  GradjDragStokes(Vec gradient);
		void	  InputUpdateFromSolutionAdjointBalancedthickness( double* solution);
		void	  InputUpdateFromSolutionAdjointHoriz( double* solution);
		void	  InputUpdateFromSolutionDiagnosticHoriz( double* solution);
		void	  InputUpdateFromSolutionDiagnosticHutter( double* solution);
		void	  InputUpdateFromSolutionOneDof(double* solution,int enum_type);
		bool	  IsInput(int name);
		ElementMatrix* NewElementMatrix(int approximation);
		ElementVector* NewElementVector(int approximation);
		void	  SetClone(int* minranks);
		void	  SurfaceNormal(double* surface_normal, double xyz_list[3][3]);
		/*}}}*/

};
#endif  /* _TRIA_H */
