/*!\file ElementVector.cpp
 * \brief: implementation of the ElementVector object, used to plug values from element into global load
 */

/*Headers:*/
/*{{{1*/
#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "stdio.h"
#include <string.h>
#include "../objects.h"
#include "../../shared/shared.h"
#include "../../Container/Container.h"
#include "../../include/include.h"
/*}}}*/

/*ElementVector constructors and destructor*/
/*FUNCTION ElementVector::ElementVector(){{{1*/
ElementVector::ElementVector(){

	this->nrows=0;
	this->values=NULL;
	this->fsize=0;
	this->finternaldoflist=NULL;
	this->fexternaldoflist=NULL;

}
/*}}}*/
/*FUNCTION ElementVector::ElementVector(int gsize,int* gexternaldoflist){{{1*/
ElementVector::ElementVector(int gsize,int* in_gexternaldoflist){

	this->nrows=gsize;
	this->pf=false;
	
	/*fill values with 0: */
	this->values=(double*)xcalloc(this->nrows,sizeof(double));
	
	/*dofs: */
	if(this->nrows){
		this->gexternaldoflist=(int*)xmalloc(nrows*sizeof(int));
		memcpy(this->gexternaldoflist,in_gexternaldoflist,nrows*sizeof(int));
	}
	else{
		this->gexternaldoflist=NULL;
	}
	/*not needed: */
	this->finternaldoflist=NULL;
	this->fexternaldoflist=NULL;

}
/*}}}*/
/*FUNCTION ElementVector::ElementVector(int gsize,int* finternaldoflist,int* fexternaldoflist,int fsize){{{1*/
ElementVector::ElementVector(int gsize,int* in_finternaldoflist,int* in_fexternaldoflist,int in_fsize){

	this->nrows=gsize;
	this->pf=true;
	
	/*fill values with 0: */
	this->values=(double*)xcalloc(this->nrows,sizeof(double));
	
	/*dofs: */
	this->fsize=in_fsize;
	if(this->fsize){
		this->finternaldoflist=(int*)xmalloc(fsize*sizeof(int));
		this->fexternaldoflist=(int*)xmalloc(fsize*sizeof(int));
		memcpy(this->finternaldoflist,in_finternaldoflist,fsize*sizeof(int));
		memcpy(this->fexternaldoflist,in_fexternaldoflist,fsize*sizeof(int));
	}
	else{
		this->finternaldoflist=NULL;
		this->fexternaldoflist=NULL;
	}
	
	/*not needed: */
	this->gexternaldoflist=NULL;

}
/*}}}*/
/*FUNCTION ElementVector::~ElementVector(){{{1*/
ElementVector::~ElementVector(){
	
	xfree((void**)&this->values);
	xfree((void**)&this->gexternaldoflist);
	xfree((void**)&this->finternaldoflist);
	xfree((void**)&this->fexternaldoflist);
}
/*}}}*/

/*ElementVector specific routines: */
/*FUNCTION ElementVector::AddValues(double* Ke_gg){{{1*/
void ElementVector::AddValues(double* pe_gg){

	int i,j;

	if(pe_gg){
		for (i=0;i<this->nrows;i++){
			this->values[i]+=pe_gg[i];
		}
	}
}
/*}}}*/
/*FUNCTION ElementVector::AddToGlobal(Vec pg, Vec pf){{{1*/
void ElementVector::AddToGlobal(Vec pg, Vec pf){

	int i;
	double* internalvalues=NULL;

	if(!pf){
		/*add internal values into global  vector, using the fexternaldoflist: */
		VecSetValues(pg,this->nrows,this->gexternaldoflist,(const double*)values,ADD_VALUES);
	}
	else{
		if(this->fsize){
			/*first, retrieve values that are in the f-set from the g-set values vector: */
			internalvalues=(double*)xmalloc(this->fsize*sizeof(double));
			for(i=0;i<this->fsize;i++){
				internalvalues[i]=this->values[this->finternaldoflist[i]];
			}
			/*add internal values into global  vector, using the fexternaldoflist: */
			VecSetValues(pf,this->fsize,this->fexternaldoflist,(const double*)internalvalues,ADD_VALUES);

			/*Free ressources:*/
			xfree((void**)&internalvalues);
		}
	}
}
/*}}}*/
