/*!\file SpcNodesx
 * \brief: establish single point constraints on all grids, as well as constraints vector.
 */

#include "./SpcNodesx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void SpcNodesx(Nodes* nodes,Constraints* constraints,int analysis_type){

	int i;
	Node* node=NULL;
	int nodeid;
	int dof;
	double value;

	for(i=0;i<constraints->Size();i++){

		Object* object=(Object*)constraints->GetObjectByOffset(i);

		/*Check constraints is a single point constraint (spc): */
		if(object->Enum()==SpcEnum){

			Spc* spc=(Spc*)object;

			if(spc->InAnalysis(analysis_type)){

				/*Ok, constraints object is a constraint. Get the nodeid from the node it applies to: */
				nodeid=spc->GetNodeId();
				dof=spc->GetDof();
				value=spc->GetValue();

				/*Now, chase through nodes and find the corect node: */
				node=(Node*)nodes->GetObjectById(NULL,nodeid);

				/*Apply constraint: */
				if(node){ //in case the spc is dealing with a node on another cpu
					node->ApplyConstraint(dof,value);
				}
			}

		}
	}

}
