/*!\file: solver_diagnostic_nonlinear.cpp
 * \brief: core of the diagnostic solution for non linear materials
 */ 

#include "../toolkits/toolkits.h"
#include "../objects/objects.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../modules/modules.h"
#include "../solutions/solutions.h"
#include "./solvers.h"

void solver_diagnostic_nonlinear(FemModel* femmodel,bool conserve_loads){

	/*parameters:*/
	bool kff=false;

	/*Recover parameters: */
	femmodel->parameters->FindParam(&kff,KffEnum);

	if(!kff) solver_diagnostic_nonlinear_kgg(femmodel,conserve_loads);
	else     solver_diagnostic_nonlinear_kff(femmodel,conserve_loads);

}
