/*!\file Riftfront.h
 * \brief: header file for riftfront object
 */

#ifndef _RIFTFRONT_H_
#define _RIFTFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

#define MAX_RIFTFRONT_GRIDS 2 //max number of grids on a rift flank, only 2 because 2d for now.
#define RIFTFRONTSTRING 20 //max string length
/*}}}*/

class Riftfront: public Load {

	public:
		int		id;
		int     analysis_type;

		Hook* hnodes; //2 nodes
		Hook* helements; //2 elements
		Hook* hmatpar;
		
		/*computational: */
		int      penalty_lock;
		bool     active;
		bool     frozen;
		int      counter;
		bool     prestable;
		bool     material_converged;
		double   normal[2];
		double   length;
		double   fraction;
		
		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;


		/*Riftfrontconstructors,destructors: {{{1*/
		Riftfront();
		Riftfront(int riftfront_id,int i, IoModel* iomodel,int analysis_type);
		~Riftfront();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void    InputUpdateFromVector(double* vector, int name, int type);
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(double* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name);
		void    InputUpdateFromConstant(int constant, int name);
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg, Mat Kff, Mat Kfs);
		void  CreatePVector(Vec pg, Vec pf);
		void  PenaltyCreateKMatrix(Mat Kgg,Mat Kff, Mat kfs, double kmax);
		void  PenaltyCreatePVector(Vec pg,Vec pf, double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Riftfront specific routines: {{{1*/
		void  GetDofList(int** pdoflist,int approximation_enum,int setenum);
		bool  PreStable();
		void  SetPreStable();
		int   PreConstrain(int* punstable);
		int   Constrain(int* punstable);
		void  FreezeConstraints(void);
		bool  IsFrozen(void);
		int   Penetration(double* ppenetration);
		int   MaxPenetration(double* ppenetration);
		int   PotentialUnstableConstraint(int* punstable);
		int   IsMaterialStable(void);
		void  OutputProperties(Vec riftproperties);
		bool  IsInput(int name);
		/*}}}*/
};

#endif  /* _RIFTFRONT_H_ */
