/*!\file Numericalflux.h
 * \brief: header file for icefront object
 */

#ifndef _NUMERICALFLUX_H_
#define _NUMERICALFLUX_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Parameters;
class Inputs;
class IoModel;

/*}}}*/

class Numericalflux: public Load {

	public: 
		int         id;
		int analysis_type;

		/*Hooks*/
		Hook*       helement;
		Hook*       hnodes;

		/*Corresponding fields*/
		Element* element;
		Node**   nodes;

		Parameters *parameters;
		Inputs     *inputs;


		/*Numericalflux constructors,destructors {{{1*/
		Numericalflux();
		Numericalflux(int numericalflux_id,int i, IoModel* iomodel,int analysis_type);
		~Numericalflux();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void    InputUpdateFromVector(double* vector, int name, int type){/*Do nothing*/}
		void    InputUpdateFromVector(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVector(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(double* vector, int name, int type){/*Do nothing*/}
		void    InputUpdateFromVectorDakota(int* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromVectorDakota(bool* vector, int name, int type){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromConstant(double constant, int name){/*Do nothing*/};
		void    InputUpdateFromConstant(int constant, int name){/*Do nothing*/};
		void    InputUpdateFromConstant(bool constant, int name){ISSMERROR("Not implemented yet!");}
		void    InputUpdateFromSolution(double* solution){ISSMERROR("Not implemented yet!");}
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Numericalflux management:{{{1*/
		void  GetJacobianDeterminant(double* pJdet,double xyz_list[4][3], double gauss_coord);
		void  GetNodalFunctions(double* l1l4, double gauss_coord);
		void  GetB(double* B, double gauss_coord);
		void  GetL(double* L, double gauss_coord,int numdof);
		void  GetDofList(int** pdoflist);
		void  GetNormal(double* normal,double xyz_list[4][3]);
		void  GetParameterValue(double* pvalue, double gauss_coord,int enumtype);
		void  GetParameterValue(double* pvalue, double gauss_coord,Input* input_in);
		void  CreateKMatrixInternal(Mat Kgg);
		void  CreateKMatrixBoundary(Mat Kgg);
		void  CreatePVectorInternal(Vec pg);
		void  CreatePVectorBoundary(Vec pg);
		/*}}}*/

};

#endif  /* _NUMERICALFLUX_H_ */
