/*!\file:  Input.h
 * \brief abstract class for Input object
 */ 


#ifndef _INPUT_H_
#define _INPUT_H_

/*Headers:*/
/*{{{1*/
#include "../Object.h"
class Node;
class ElementResult;
class GaussTria;
/*}}}*/

class Input: public Object{

	public: 
		
		virtual        ~Input(){};
		/*Virtual functions:{{{1*/
		virtual int  EnumType()=0; 
		virtual void GetParameterValue(bool* pvalue)=0;
		virtual void GetParameterValue(int* pvalue)=0;
		virtual void GetParameterValue(double* pvalue)=0;
		virtual void GetParameterValue(double* pvalue,double* gauss)=0;
		virtual void GetParameterValue(double* pvalue,GaussTria* gauss)=0;
		virtual void GetParameterValue(double* pvalue,GaussPenta* gauss)=0;
		virtual void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss)=0;
		virtual void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss)=0;
		virtual void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetParameterAverage(double* pvalue)=0;
		virtual void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss)=0;
		virtual void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss)=0;
		virtual void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss)=0;
		virtual void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss)=0;
		virtual void ChangeEnum(int newenumtype)=0;

		virtual void   SquareMin(double* psquaremin, bool process_units,Parameters* parameters)=0;
		virtual void   ConstrainMin(double minimum)=0;
		virtual double InfinityNorm(void)=0;
		virtual double MaxAbs(void)=0;
		virtual double MinAbs(void)=0;
		virtual double Max(void)=0;
		virtual double Min(void)=0;
		virtual void   Scale(double scale_factor)=0;
		virtual void   ArtificialNoise(double min,double max)=0;
		virtual void   AXPY(Input* xinput,double scalar)=0;
		virtual void   Constrain(double cm_min, double cm_max)=0;
		virtual void   VerticallyIntegrate(Input* thickness_input)=0;
		virtual void   Extrude()=0;
		virtual void   GetVectorFromInputs(Vec vector,int* doflist)=0;
		virtual void   GetValuesPtr(double** pvalues,int* pnum_values)=0;
		
		virtual Input* SpawnTriaInput(int* indices)=0;
		virtual Input* PointwiseDivide(Input* inputB)=0;
		virtual ElementResult* SpawnResult(int step, double time)=0;

		/*}}}*/

};
#endif
