/*!\file Pengrid.h
 * \brief: header file for pengrid object */

#ifndef _PENGRID_H_
#define _PENGRID_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class IoModel;
/*}}}*/

class Pengrid: public Load{

	private: 

		int		id;
		int analysis_type;
		
		/*Hooks*/
		Hook* hnode;  //hook to 1 node
		Hook* helement;  //hook to 1 element
		Hook* hmatpar; //hook to 1 matpar

		/*Corresponding fields*/
		Node    *node;
		Element *element;
		Matpar  *matpar;

		Parameters* parameters; //pointer to solution parameters
		Inputs*  inputs;
	
		/*internals: */
		int active;
		int zigzag_counter;

	public:

		/*Pengrid constructors, destructors {{{1*/
		Pengrid();
		Pengrid(int index, int id, IoModel* iomodel,int analysis_type);
		~Pengrid();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions resolution: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Pengrid management {{{1*/
		void  PenaltyCreateKMatrixDiagnosticStokes(Mat Kgg,double kmax);
		void  GetDofList(int** pdoflist);
		void  PenaltyCreateKMatrixThermal(Mat Kgg,double kmax);
		void  PenaltyCreateKMatrixMelting(Mat Kgg,double kmax);
		void  PenaltyCreatePVectorThermal(Vec pg, double kmax);
		void  PenaltyCreatePVectorMelting(Vec pg, double kmax);
		void  PenaltyConstrain(int* punstable);
		void  PenaltyConstrainThermal(int* punstable);
		void  UpdateInputs(double* solution);
		/*}}}*/

};

#endif  /* _PENGRID_H_ */


