/*!\file Icefront.h
 * \brief: header file for icefront object
 */

#ifndef _ICEFRONT_H_
#define _ICEFRONT_H_

/*Headers:*/
/*{{{1*/
#include "./Load.h"
class Hook;
class Inputs;
class Parameters;
class Matpar;
class Node;
class Element;
class IoModel;
/*}}}*/

class Icefront: public Load {

	public:
		int id;
		int analysis_type;

		/*hooks: */
		Hook* hnodes;
		Hook* helement;
		Hook* hmatpar;

		/*Corresponding fields*/
		Matpar   *matpar;
		Node    **nodes;
		Element  *element;

		/*inputs and parameters: */
		Inputs* inputs;
		Parameters* parameters;

		/*Icefront constructors, destructors: {{{1*/
		Icefront();
		Icefront(int icefront_id,int i, IoModel* iomodel,int in_icefront_type, int analysis_type);
		~Icefront();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*Update virtual functions definitions: {{{1*/
		void  InputUpdateFromVector(double* vector, int name, int type);
		void  InputUpdateFromVector(int* vector, int name, int type);
		void  InputUpdateFromVector(bool* vector, int name, int type);
		void  InputUpdateFromVectorDakota(double* vector, int name, int type);
		void  InputUpdateFromVectorDakota(int* vector, int name, int type);
		void  InputUpdateFromVectorDakota(bool* vector, int name, int type);
		void  InputUpdateFromConstant(double constant, int name);
		void  InputUpdateFromConstant(int constant, int name);
		void  InputUpdateFromConstant(bool constant, int name);
		void  InputUpdateFromSolution(double* solution);
		/*}}}*/
		/*Load virtual functions definitions: {{{1*/
		void  Configure(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  SetCurrentConfiguration(Elements* elements,Loads* loads,Nodes* nodes,Vertices* vertices,Materials* materials,Parameters* parameters);
		void  CreateKMatrix(Mat Kgg);
		void  CreatePVector(Vec pg);
		void  PenaltyCreateKMatrix(Mat Kgg,double kmax);
		void  PenaltyCreatePVector(Vec pg,double kmax);
		bool  InAnalysis(int analysis_type);
		/*}}}*/
		/*Load management: {{{1*/
		void  CreatePVectorDiagnosticMacAyeal2d(Vec pg);
		void  CreatePVectorDiagnosticMacAyeal3d(Vec pg);
		void  CreatePVectorDiagnosticPattyn(Vec pg);
		void  CreatePVectorDiagnosticStokes(Vec pg);
		void  GetDofList(int** pdoflist,int approximation_enum=0);
		void  QuadPressureLoad(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void  QuadPressureLoadStokes(double* pe_g,double rho_water,double rho_ice,double gravity, double* thickness_list, double* bed_list, 
		                              double* normal1,double* normal2,double* normal3,double* normal4,double* xyz_list);
		void GetParameterValue(double* pvalue, double gauss_coord,Input* input_in);
		void GetNormal(double* normal,double xyz_list[2][3]);
		/*}}}*/
};

#endif  /* _ICEFRONT_H_ */
