/*\file Solver.c
 *\brief: solver
 */

#include "./Solver.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	Mat         Kff           = NULL;
	Vec         pf            = NULL;
	Vec         uf0           = NULL;
	Vec         uf            = NULL;
	char       *solver_string = NULL;
	Parameters *parameters    = NULL;
	int         verbose;
		
	/*Matlab solver: */
	mxArray* array[2];
	char* matlabstring="-ksp_type matlab";

	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&SolverUsage);

	/*First, check solver string: */
	FetchParams(&parameters,PARAMETERS);
	parameters->FindParam(&solver_string,SolverStringEnum);
	int verbose; parameters->FindParam(&verbose,VerboseEnum);
	
	/*Fetch rest of data only if not running the matlab solver: */
	if (strcmp(solver_string,matlabstring)!=0){
		/*Input datasets: */
		FetchData(&Kff,KFF);
		FetchData(&pf,PF);
		FetchData(&uf0,UF0);
		/*Petsc solver: */
		Solverx(&uf, Kff, pf, uf0, parameters);
		/*Write output*/
		WriteData(UF,uf);
	}
	else{
		/*Matlab solver: */
		if (verbose) printf("   Solving\n");
		array[0]=KFF;
		array[1]=PF;
		mexCallMATLAB(1,UF,2,array,"mldivide");
	}

	/*Free ressources: */
	MatFree(&Kff);
	VecFree(&pf);
	VecFree(&uf0);
	VecFree(&uf);
	delete parameters;
	xfree((void**)&solver_string);

	MODULEEND();
}

void SolverUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [uf] = %s(Kff,pf,uf0,parameters);\n",__FUNCT__);
	_printf_("\n");
}
