function femmodel=solver_linear(femmodel)
%SOLVER_LINEAR - core solver of any linear solution sequence
%
%   Usage:
%      femmodel =solver_linear(femmodel)

	[K_gg, p_g,kmax]=SystemMatrices(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);
	
	[K_ff, K_fs] = Reducematrixfromgtof( K_gg,  femmodel.nodesets,femmodel.parameters); 
	p_f = Reduceloadfromgtof( p_g,  K_fs, femmodel.ys, femmodel.nodesets,femmodel.parameters);

	displaystring(femmodel.parameters.Verbose>1,'%s%g','      condition number of stiffness matrix: ',condest(K_ff));
	u_f=Solver(K_ff,p_f,[],femmodel.parameters);
	
	u_g= Mergesolutionfromftog( u_f, femmodel.ys, femmodel.nodesets,femmodel.parameters); 

	[femmodel.elements,femmodel.materials]=InputUpdateFromSolution(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,u_g);
