function md=tres(md,string)
%TRES - transfer results results to corresponding model fields. 
%
%    Usage: md=tres(md,string)
%
%    Example: md=tres(md,'diagnostic');

%check number of arguments

if strcmpi(string,'diagnostic'),
	if md.dim==2,
		if isfield(md.results.DiagnosticSolution,'VxAverage'),
			md.vx=PatchToVec(md.results.DiagnosticSolution.VxAverage);
		else
			md.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
		end
		if isfield(md.results.DiagnosticSolution,'VyAverage'),
			md.vy=PatchToVec(md.results.DiagnosticSolution.VyAverage);
		else
			md.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
		end
	else 
		md.vx=PatchToVec(md.results.DiagnosticSolution.Vx);
		md.vy=PatchToVec(md.results.DiagnosticSolution.Vy);
		if isfield(md.results.DiagnosticSolution,'Vz'),
			md.vz=PatchToVec(md.results.DiagnosticSolution.Vz);
		else
			md.vz=zeros(md.numberofgrids,1);
		end
	end
	md.vel=PatchToVec(md.results.DiagnosticSolution.Vel);

	if isfield(md.results.DiagnosticSolution,'Pressure'),
		md.pressure=PatchToVec(md.results.DiagnosticSolution.Pressure);
	end
	if md.numrifts,
		if isfield(md.results.DiagnosticSolution,'riftproperties'),
			md.riftproperties=md.results.DiagnosticSolution.riftproperties;
		end
	end
	if md.control_analysis==1,
		if (md.control_type==DragCoefficientEnum)
			md.drag_coefficient=PatchToVec(md.results.DiagnosticSolution.(md.results.DiagnosticSolution.ControlType));
		elseif (md.control_type==RheologyBbarEnum)
			md.rheology_B=PatchToVec(md.results.DiagnosticSolution.(md.results.DiagnosticSolution.ControlType));
		elseif (md.control_type==DhDtEnum)
			md.dhdt=PatchToVec(md.results.DiagnosticSolution.(md.results.DiagnosticSolution.ControlType));
		else
			error('control type not implemented yet')
		end
	end
elseif strcmpi(string,'dakota'),
	md.dakotaresults=md.results.dakota;
elseif strcmpi(string,'steadystate'),
	md.vx=PatchToVec(md.results.SteadystateSolution.Vx);
	md.vy=PatchToVec(md.results.SteadystateSolution.Vy);
	if isfield(md.results.SteadystateSolution,'Vz'),
		md.vz=PatchToVec(md.results.SteadystateSolution.Vz);
	end

	md.vel=PatchToVec(md.results.SteadystateSolution.Vel);
	md.pressure=PatchToVec(md.results.SteadystateSolution.Pressure);
	md.temperature=PatchToVec(md.results.SteadystateSolution.Temperature);
	md.melting_rate=PatchToVec(md.results.SteadystateSolution.MeltingRate);
elseif strcmpi(string,'thermal'),
	md.temperature=PatchToVec(md.results.ThermalSolution.Temperature);
	md.melting_rate=PatchToVec(md.results.ThermalSolution.MeltingRate);
else 
	error(['tres error message: analysis ' string ' not supported yet!']);
end
