/*
 * parallel.h: 
 */

#ifndef PARALLEL_H_
#define PARALLEL_H_

#include "../objects/objects.h"
#include "../io/io.h"

Vec GradJCompute(ParameterInputs* inputs,FemModel* femmodel,double* u_g_obs);

void diagnostic_core(Vec* pug, Vec* ppg,FemModel* fems, ParameterInputs* inputs);
void diagnostic_core_nonlinear(Vec* pug,Mat* pK_ff0,Mat* pK_fs0, FemModel* fem,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);
void diagnostic_core_linear(Vec* ppg,FemModel* fem,ParameterInputs* inputs,int  analysis_type,int sub_analysis_type);
void thermal_core(Vec* pt_g,double* pmelting_offset,FemModel* femmodel,ParameterInputs* inputs,int analysis_type,int sub_analysis_type);

//int GradJOrth(WorkspaceParams* workspaceparams);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*,ParameterInputs*),FemModel* femmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*,ParameterInputs*),FemModel* femmodel);
	
double objectivefunctionC(double search_scalar,OptArgs* optargs);

int GradJSearch(double* search_vector,FemModel* femmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void OutputDiagnostic(Vec u_g,Vec p_g, FemModel* femmodels,char* filename);
void OutputThermal(Vec* t_g,Vec* m_g, double* time,FemModel* femmodels,char* filename);
void OutputControl(Vec u_g,double* p_g, double* J, int nsteps, Vec partition,char* filename,NodeSets* nodesets);
void WriteLockFile(char* filename);

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,char* analysis_type,char* sub_analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femmodel,char* filename);

#endif
