/*\file Reduceloadfromgtof.c
 *\brief: reduce load from g set to f set
 */

#include "./Reduceloadfromgtof.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*input datasets: */
	bool        flag_ys0;
	Vec         pg         = NULL;
	Mat         Kfs        = NULL;
	Vec         ys         = NULL;
	NodeSets   *nodesets   = NULL;
	Parameters *parameters = NULL;

	/* output datasets: */
	Vec pf=NULL;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	if((nlhs!=NLHS) || (nrhs!=5 && nrhs!=6)){
		ReduceloadfromgtofUsage();
		ISSMERROR(" usage. See above");
	}

	/*Input datasets: */
	FetchData(&pg,PG);
	FetchData(&Kfs,KFS);
	FetchData(&ys,YS);
	FetchNodeSets(&nodesets,NODESETS);
	FetchParams(&parameters,PARAMETERS);

	/*!Reduce load from g to f size: */
	if (nrhs==5){
		Reduceloadfromgtofx(&pf, pg, Kfs, ys, nodesets,parameters);
	}
	else{
		FetchData(&flag_ys0,YSFLAG);
		Reduceloadfromgtofx(&pf, pg, Kfs, ys, nodesets,parameters,flag_ys0);
	}


	/*write output datasets: */
	WriteData(PF,pf);

	/*Free ressources: */
	VecFree(&pg);
	MatFree(&Kfs);
	VecFree(&ys);
	delete nodesets;
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ReduceloadfromgtofUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [pf] = %s(pg,Kfs,ys,nodesets,parameters);\n",__FUNCT__);
	_printf_("\n");
}
