/*!\file Reduceloadfromgtofx
 * \brief reduce loads from g set to f set 
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif
#include "./Reduceloadfromgtofx.h"

void	Reduceloadfromgtofx( Vec* ppf, Vec pg, Mat Kfs, Vec y_s, NodeSets* nodesets,Parameters* parameters,bool flag_ys0){

	/*output: */
	Vec pf=NULL;

	/*intermediary*/
	Vec y_s0=NULL;
	Vec pn=NULL;
	Vec Kfsy_s=NULL;
	int Kfsm,Kfsn;
	PetscScalar a;

	/*Display message*/
	int verbose; parameters->FindParam(&verbose,VerboseEnum);
	if (verbose) printf("   Reducing Load vector from gset to fset\n");

	if(!pg){
		pf=NULL;
	}
	else{
		/* Reduce pg to pn:*/
		VecDuplicate(pg,&pn);  
		VecCopy(pg,pn);  
		
		/*% Reduce pn to pf:*/

		if (nodesets->GetSSize()){

			if(nodesets->GetFSize()){
				VecPartition(&pf, pn, nodesets->GetPV_F(),nodesets->GetFSize());

				/*pf = pf - Kfs * y_s;*/
				MatGetLocalSize(Kfs,&Kfsm,&Kfsn);
				Kfsy_s=NewVecFromLocalSize(Kfsm);
				if (flag_ys0){

					/*Create y_s0, full of 0: */
					VecDuplicate(y_s,&y_s0);
					VecSet(y_s0,0.0);
					VecAssemblyBegin(y_s0);
					VecAssemblyEnd(y_s0);

					MatMultPatch(Kfs,y_s0,Kfsy_s);
				}
				else{
					MatMultPatch(Kfs,y_s,Kfsy_s);
				}

				a=-1;
				VecAXPY(pf,a,Kfsy_s);  
			}
			else{
				pf=NULL;
			}
		}
		else{
			/*pf=pn*/
			VecDuplicate(pn,&pf);  
			VecCopy(pn,pf);  
		}
	}
	
	
	/*Assign correct pointer*/
	*ppf=pf;

	/*Free ressources and return*/
	VecFree(&y_s0);
	VecFree(&pn);
	VecFree(&Kfsy_s);

}
