/*!\file PenaltySystemMatricesx
 * \brief: add penalties to system matrices
 */

#include "./PenaltySystemMatricesx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"

void PenaltySystemMatricesx(Mat Kgg, Vec pg,double* pkmax,Elements* elements,Nodes* nodes, Vertices* vertices,Loads* loads,Materials* materials, Parameters* parameters, int kflag,int pflag){
	
	int i;
	double kmax;
	Load* load=NULL;
	int configuration_type;

	/*Display message*/
	int verbose; parameters->FindParam(&verbose,VerboseEnum);
	if (verbose) printf("   Generating penalty matrices\n");

	/*retrive parameters: */
	parameters->FindParam(&configuration_type,ConfigurationTypeEnum);

	/*Now, figure out maximum value of K_gg, so that we can penalize it correctly: */
	MatNorm(Kgg,NORM_INFINITY,&kmax);

	/*Add penalties to stiffnesses, from loads: */
	if(kflag){

		/*Fill stiffness matrix from loads: */
		for (i=0;i<loads->Size();i++){
			load=(Load*)loads->GetObjectByOffset(i);
			if (load->InAnalysis(configuration_type)) load->PenaltyCreateKMatrix(Kgg,kmax);
		}

		/*Assemble matrix and compress matrix to save memory: */
		MatAssemblyBegin(Kgg,MAT_FINAL_ASSEMBLY);
		MatAssemblyEnd(Kgg,MAT_FINAL_ASSEMBLY);
		MatCompress(Kgg);
	}

	/*Add penalties to right hand side, from loads: */
	if(pflag){

		/*Fill right hand side vector, from loads: */
		for (i=0;i<loads->Size();i++){
			load=(Load*)loads->GetObjectByOffset(i);
			if (load->InAnalysis(configuration_type)) load->PenaltyCreatePVector(pg,kmax);
		}

		/*Assemble right hand side: */
		VecAssemblyBegin(pg);
		VecAssemblyEnd(pg);
	}
	
	/*Assign output pointer:*/
	if(pkmax) *pkmax=kmax;

}
