/*!\file GaussSeg.c
 * \brief: implementation of the GaussSeg object
 */

/*Include files: {{{1*/
#include "./../objects.h"
/*}}}*/

/*GaussSeg constructors and destructors:*/
/*FUNCTION GaussSeg::GaussSeg() {{{1*/
GaussSeg::GaussSeg(){

	numgauss=-1;

	weights=NULL;
	coords=NULL;

	weight=UNDEF;
	coord=UNDEF;
}
/*}}}*/
/*FUNCTION GaussSeg::GaussSeg(int order) {{{1*/
GaussSeg::GaussSeg(int order){

	/*Get gauss points*/
	numgauss=order;
	GaussLegendreLinear(&coords,&weights,order);

	/*Initialize static fields as undefinite*/
	weight=UNDEF;
	coord=UNDEF;

}
/*}}}*/
/*FUNCTION GaussSeg::~GaussSeg(){{{1*/
GaussSeg::~GaussSeg(){
	xfree((void**)&weights);
	xfree((void**)&coords);
}
/*}}}*/

/*Methods*/
/*FUNCTION GaussSeg::Echo{{{1*/
void GaussSeg::Echo(void){

	printf("GaussSeg:\n");
	printf("   numgauss: %i\n",numgauss);

	if (weights){
	 printf("   weights = ["); 
	 for(int i=0;i<numgauss;i++) printf(" %g\n",weights[i]);
	 printf("]\n");
	}
	else printf("weights = NULL\n");
	if (coords){
	 printf("   coords = ["); 
	 for(int i=0;i<numgauss;i++) printf(" %g\n",coords[i]);
	 printf("]\n");
	}
	else printf("coords = NULL\n");

	printf("   weight = %g\n",weight);
	printf("   coord  = %g\n",coord);

}
/*}}}*/
/*FUNCTION GaussSeg::GaussCenter{{{1*/
void GaussSeg::GaussCenter(void){

	/*update static arrays*/
	coord=0.0;

}
/*}}}*/
/*FUNCTION GaussSeg::GaussPoint{{{1*/
void GaussSeg::GaussPoint(int ig){

	/*Check input in debugging mode*/
	 ISSMASSERT(ig>=0 && ig< numgauss);

	 /*update static arrays*/
	 weight=weights[ig];
	 coord=coords[ig];

}
/*}}}*/
/*FUNCTION GaussSeg::GaussVertex{{{1*/
void GaussSeg::GaussVertex(int iv){

	/*in debugging mode: check that the default constructor has been called*/
	ISSMASSERT(numgauss==-1);

	/*update static arrays*/
	switch(iv){
		case 0:
			coord=-1.0;
			break;
		case 1:
			coord=1.0;
			break;
		default:
			ISSMERROR("vertex index should be in [0 1]");

	}

}
/*}}}*/
/*FUNCTION GaussSeg::begin{{{1*/
int GaussSeg::begin(void){

	/*Check that this has been initialized*/
	ISSMASSERT(numgauss>0);
	ISSMASSERT(weights);
	ISSMASSERT(coords);

	/*return first gauss index*/
	return 0;
}
/*}}}*/
/*FUNCTION GaussSeg::end{{{1*/
int GaussSeg::end(void){

	/*Check that this has been initialized*/
	ISSMASSERT(numgauss>0);
	ISSMASSERT(weights);
	ISSMASSERT(coords);

	/*return last gauss index +1*/
	return numgauss;
}
/*}}}*/
