/*! \file BoolInput.h 
 *  \brief: header file for triavertexinput object
 */


#ifndef _BOOLINPUT_H_
#define _BOOLINPUT_H_

/*Headers:*/
/*{{{1*/
#include "./Input.h"
#include "../../include/include.h"
class GaussTria;
/*}}}*/

class BoolInput: public Input{

	public:
		/*just hold 3 values for 3 vertices: */
		int    enum_type;
		IssmBool value;

		/*BoolInput constructors, destructors: {{{1*/
		BoolInput();
		BoolInput(int enum_type,IssmBool value);
		~BoolInput();
		/*}}}*/
		/*Object virtual functions definitions:{{{1 */
		void  Echo();
		void  DeepEcho();
		int   Id(); 
		int   MyRank();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		Object* copy();
		/*}}}*/
		/*BoolInput management: {{{1*/
		int   EnumType();
		Input* SpawnTriaInput(int* indices);
		Input* PointwiseDivide(Input* inputB){ISSMERROR("not implemented yet");};
		ElementResult* SpawnResult(int step, double time);
		/*}}}*/
		/*numerics: {{{1*/
		void GetParameterValue(bool* pvalue);
		void GetParameterValue(int* pvalue);
		void GetParameterValue(double* pvalue);
		void GetParameterValue(double* pvalue,double* gauss);
		void GetParameterValue(double* pvalue,GaussTria* gauss);
		void GetParameterValue(double* pvalue,GaussPenta* gauss);
		void GetParameterValues(double* values,double* gauss_pointers, int numgauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, double* gauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussTria* gauss);
		void GetParameterDerivativeValue(double* derivativevalues, double* xyz_list, GaussPenta* gauss);
		void GetParameterAverage(double* pvalue){ISSMERROR("not implemented yet");};
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, double* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate2d(double* epsilonvx,double* xyz_list, GaussTria* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate2d(double* epsilonvy,double* xyz_list, GaussTria* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3d(double* epsilonvx,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3d(double* epsilonvy,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVzStrainRate3d(double* epsilonvz,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVxStrainRate3dPattyn(double* epsilonvx,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void GetVyStrainRate3dPattyn(double* epsilonvy,double* xyz_list, GaussPenta* gauss){ISSMERROR("not implemented yet");};
		void ChangeEnum(int newenumtype);
		void SquareMin(double* psquaremin, bool process_units,Parameters* parameters);
		void ConstrainMin(double minimum){ISSMERROR("not implemented yet");};
		double InfinityNorm(void){ISSMERROR("InfinityNorm not implemented for booleans");};
		double Max(void){ISSMERROR("Max not implemented for booleans");};
		double MaxAbs(void){ISSMERROR("Max not implemented for booleans");};
		double Min(void){ISSMERROR("Min not implemented for booleans");};
		double MinAbs(void){ISSMERROR("Min not implemented for booleans");};
		void Scale(double scale_factor);
		void ArtificialNoise(double min,double max){ISSMERROR("not implemented yet");};
		void AXPY(Input* xinput,double scalar);
		void Constrain(double cm_min, double cm_max);
		void Extrude(void){ISSMERROR("not supported yet");};
		void VerticallyIntegrate(Input* thickness_input){ISSMERROR("not supported yet");};
		void GetVectorFromInputs(Vec vector,int* doflist);
		void GetValuesPtr(double** pvalues,int* pnum_values);
		/*}}}*/

};
#endif  /* _BOOLINPUT_H */
