/*!\file GaussTria.c
 * \brief: implementation of the GaussTria object
 */

/*Include files: {{{1*/
#include "./../objects.h"
/*}}}*/

/*GaussTria constructors and destructors:*/
/*FUNCTION GaussTria::GaussTria() {{{1*/
GaussTria::GaussTria(){

	numgauss=-1;

	weights=NULL;
	coords1=NULL;
	coords2=NULL;
	coords3=NULL;

	weight=UNDEF;
	coord1=UNDEF;
	coord2=UNDEF;
	coord3=UNDEF;
}
/*}}}*/
/*FUNCTION GaussTria::GaussTria(int order) {{{1*/
GaussTria::GaussTria(int order){

	/*Get gauss points*/
	GaussLegendreTria(&numgauss,&coords1,&coords2,&coords3,&weights,order);

	/*Initialize static fields as undefinite*/
	weight=UNDEF;
	coord1=UNDEF;
	coord2=UNDEF;
	coord3=UNDEF;

}
/*}}}*/
/*FUNCTION GaussTria::GaussTria(int order,int node1,int node2) {{{1*/
GaussTria::GaussTria(int order,int node1,int node2){

	ISSMERROR("not implemented yet");

	/*Get gauss points*/
	GaussLegendreTria(&numgauss,&coords1,&coords2,&coords3,&weights,order);

	/*Initialize static fields as undefinite*/
	weight=UNDEF;
	coord1=UNDEF;
	coord2=UNDEF;
	coord3=UNDEF;

}
/*}}}*/
/*FUNCTION GaussTria::~GaussTria(){{{1*/
GaussTria::~GaussTria(){
	xfree((void**)&weights);
	xfree((void**)&coords1);
	xfree((void**)&coords2);
	xfree((void**)&coords3);
}
/*}}}*/

/*Methods*/
/*FUNCTION GaussTria::Echo{{{1*/
void GaussTria::Echo(void){

	printf("GaussTria:\n");
	printf("   numgauss: %i\n",numgauss);

	if (weights){
	 printf("   weights = ["); 
	 for(int i=0;i<numgauss;i++) printf(" %g\n",weights[i]);
	 printf("]\n");
	}
	else printf("weights = NULL\n");
	if (coords1){
	 printf("   coords1 = ["); 
	 for(int i=0;i<numgauss;i++) printf(" %g\n",coords1[i]);
	 printf("]\n");
	}
	else printf("coords1 = NULL\n");
	if (coords2){
	 printf("   coords2 = ["); 
	 for(int i=0;i<numgauss;i++) printf(" %g\n",coords2[i]);
	 printf("]\n");
	}
	else printf("coords2 = NULL\n");
	if (coords3){
	 printf("   coords3 = ["); 
	 for(int i=0;i<numgauss;i++) printf(" %g\n",coords3[i]);
	 printf("]\n");
	}
	else printf("coords3 = NULL\n");

	printf("   weight = %g\n",weight);
	printf("   coord1 = %g\n",coord1);
	printf("   coord2 = %g\n",coord2);
	printf("   coord3 = %g\n",coord3);

}
/*}}}*/
/*FUNCTION GaussTria::GaussPoint{{{1*/
void GaussTria::GaussPoint(int ig){

	/*Check input in debugging mode*/
	 ISSMASSERT(ig>=0 && ig< numgauss);

	 /*update static arrays*/
	 weight=weights[ig];
	 coord1=coords1[ig];
	 coord2=coords2[ig];
	 coord3=coords3[ig];

}
/*}}}*/
/*FUNCTION GaussTria::GaussVertex{{{1*/
void GaussTria::GaussVertex(int iv){

	/*in debugging mode: check that the default constructor has been called*/
	ISSMASSERT(numgauss==-1);

	/*update static arrays*/
	switch(iv){
		case 0:
			coord1=1; coord2=0; coord3=0;
			break;
		case 1:
			coord1=0; coord2=1; coord3=0;
			break;
		case 2:
			coord1=0; coord2=0; coord3=1;
			break;
		default:
			ISSMERROR("vertex index should be in [0 2]");

	}

}
/*}}}*/
/*FUNCTION GaussTria::begin{{{1*/
int GaussTria::begin(void){

	/*Check that this has been initialized*/
	ISSMASSERT(numgauss>0);
	ISSMASSERT(weights);
	ISSMASSERT(coords1);
	ISSMASSERT(coords2);
	ISSMASSERT(coords3);

	/*return first gauss index*/
	return 0;
}
/*}}}*/
/*FUNCTION GaussTria::end{{{1*/
int GaussTria::end(void){

	/*Check that this has been initialized*/
	ISSMASSERT(numgauss>0);
	ISSMASSERT(weights);
	ISSMASSERT(coords1);
	ISSMASSERT(coords2);
	ISSMASSERT(coords3);

	/*return last gauss index +1*/
	return numgauss;
}
/*}}}*/
