/*!\file:  TriaRef.h
 * \brief abstract class for handling Tria oriented routines, like nodal functions, 
 * strain rate generation, etc ...
 */ 


#ifndef _TRIAREF_H_
#define _TRIAREF_H_

class GaussTria;

class TriaRef{
	

	public: 
		int* element_type_list; //P1CG, P1DG, MINI, P2...
		int  element_type;
		
		TriaRef();
		TriaRef(const int nummodels);
		~TriaRef();

		/*Management*/
		void SetElementType(int type,int type_counter);

		/*Numerics*/
		void GetBMacAyeal(double* B, double* xyz_list, double* gauss);
		void GetBprimeMacAyeal(double* Bprime, double* xyz_list, double* gauss);
		void GetBprimePrognostic(double* Bprime_prog, double* xyz_list, double* gauss);
		void GetBPrognostic(double* B_prog, double* xyz_list, double* gauss);
		void GetL(double* L, double* xyz_list,double* gauss,int numdof);
		void GetL(double* L, double* xyz_list,GaussTria* gauss,int numdof);
		void GetJacobian(double* J, double* xyz_list,double* gauss);
		void GetJacobian(double* J, double* xyz_list,GaussTria* gauss);
		void GetJacobianDeterminant2d(double* Jdet, double* xyz_list,double* gauss);
		void GetJacobianDeterminant2d(double* Jdet, double* xyz_list,GaussTria* gauss);
		void GetJacobianDeterminant3d(double* Jdet, double* xyz_list,double* gauss);
		void GetJacobianInvert(double*  Jinv, double* xyz_list,double* gauss);
		void GetNodalFunctions(double* l1l2l3, double* gauss);
		void GetNodalFunctions(double* l1l2l3,GaussTria* gauss);
		void GetNodalFunctionsDerivatives(double* l1l2l3,double* xyz_list, double* gauss);
		void GetNodalFunctionsDerivativesReference(double* dl1dl3,double* gauss);
		void GetParameterValue(double* pp, double* plist, double* gauss);
		void GetParameterDerivativeValue(double* pp, double* plist,double* xyz_list, double* gauss);

};
#endif
