%  --  vim --
!vim runme.m
%  --  tests  --
md=runme('id',101);
runme('id',[101]);
%  --  tweak parameters --
md.numberofelements
md.numberofgrids
%  --  model set up  --
md=mesh(md,'DomainOutline.exp',5000);
md=geography(md,'','');
md=geography(md,'Iceshelves.exp','Islands.exp');
md=parameterize(md,'Antarctica.par');
md=extrude(md,8,1);
md=setelementstype(md,'macayeal','all');
md=setelementstype(md,'pattyn','all','stokes','all');
%  --  execution --
md=solve(md,'analysis_type',ThermalSolutionEnum);
md=solve(md,'analysis_type',BalancedthicknessSolutionEnum);
md=solve(md,'analysis_type',DiagnosticSolutionEnum);
md=loadresultsfromcluster(md);
md=tres(md,ThermalSolutionEnum);
md=tres(md,DiagnosticSolutionEnum);
%  --  plots  --
plotmodel(md,'data',md.results.DiagnosticSolution.Vel)
