
/*
	OutputThermal.c: output model results for thermal solution.
*/
#undef __FUNCT__ 
#define __FUNCT__ "OutputThermal"

#include "../toolkits/toolkits.h"
#include "../EnumDefinitions/EnumDefinitions.h"
#include "../shared/shared.h"
#include "../io/io.h"
#include "../objects/objects.h"

void OutputThermal(Vec* t_g,Vec* m_g, FemModel* femmodels,char* filename){

	int i;
	extern int my_rank;
	
	/* output: */
	FILE* fid=NULL;

	/*intermediary: */
	FemModel*  fem=NULL;
	NodeSets* nodesets=NULL;
	Vec       partition=NULL;
	char*     analysis_type="thermal";
	
	/* standard output: */
	Vec partition_shifted=NULL;
	double* serial_partition=NULL;

	double** serial_tg=NULL;
	double** serial_mg=NULL;

	double ndt,dt;
	int    nsteps;
	int    sub_analysis_type;
	
	int     one=1;
	int     nods;

	/*Recover thermal horiz femmodel: */
	fem=femmodels+0;
	
	partition=fem->partition;
	nodesets=fem->nodesets;

	fem->parameters->FindParam((void*)&dt,"dt");
	fem->parameters->FindParam((void*)&ndt,"ndt");
	fem->parameters->FindParam((void*)&sub_analysis_type,"sub_analysis_type");

	/*serialize outputs: */
	VecDuplicate(partition,&partition_shifted);
	VecCopy(partition,partition_shifted);
	VecShift(partition_shifted,1.0); //matlab indexing starts at 1
	
	VecToMPISerial(&serial_partition,partition_shifted);
	VecGetSize(partition,&nods);


	if(sub_analysis_type==SteadyAnalysisEnum()){
		nsteps=0;
	}
	else{
		nsteps=(int)(ndt/dt);
	}

	/*allocate t_g and m_g arrays: */
	serial_tg=(double**)xmalloc((nsteps+1)*sizeof(double*));
	serial_mg=(double**)xmalloc((nsteps+1)*sizeof(double*));

	/*get tg_i*/
	for(i=0;i<=nsteps;i++){
		VecToMPISerial(&serial_tg[i],t_g[i]);
		VecToMPISerial(&serial_mg[i],m_g[i]);
	}
	
	/* Open output file to write raw binary data: */
	if(my_rank==0){

		fid=pfopen(filename,"wb");

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&nods,&one,"Mat",fid);
		
		/*Write number of steps: */
		WriteDataToDisk(&nsteps,NULL,NULL,"Integer",fid);

		/*Write solutions to disk: */
		for(i=0;i<=nsteps;i++){
			WriteDataToDisk(serial_tg[i],&nods,&one,"Mat",fid);
			WriteDataToDisk(serial_mg[i],&nods,&one,"Mat",fid);
		}
	
		/*Close file: */
		pfclose(fid,filename);
	}

	/*Free ressources: */
	VecFree(&partition_shifted);
	xfree((void**)&serial_partition);
	xfree((void**)&serial_tg);
	xfree((void**)&serial_mg);
}	
