#!/bin/bash
#generate html report from info.log output file

#----------------------------#
# Initialize local variables #
#----------------------------#

#process info.log
TODAY=`     cat info.log | grep "today"           | awk '{printf("%s %s",$2,$3);}'`
USER=`      cat info.log | grep "user"            | awk '{print $2}'`
HOST_NAME=` cat info.log | grep "host"            | awk '{print $2}'`
OS=`        cat info.log | grep "OS"              | awk '{print $2}'`
RELEASE=`   cat info.log | grep "release"         | awk '{print $2}'`
EL_INSTALL=`cat info.log | grep "elapsed_install" | awk '{print $2}'`
EL_RUN=`    cat info.log | grep "elapsed_run"     | awk '{print $2}'`
EL_TOTAL=`  cat info.log | grep "elapsed_total"   | awk '{print $2}'`
CRASH=`     cat info.log | grep "matlab_crash:"   | awk '{print $2}'`

#Process matlab_log.log
cat matlab_log.log        | egrep 'ERROR|SUCCESS|FAILURE' | sed -e "s/>/\&gt;/g" | sed -e "s/</\&lt;/g" > matlab.log
NUM_TOT=`wc -l matlab.log | awk '{print $1}'`
NUM_ERR=`cat matlab.log | grep 'ERROR'   | grep -v "PETSC ERROR" | wc -l`
NUM_SUC=`cat matlab.log | grep 'SUCCESS' | wc -l`
NUM_FAI=`cat matlab.log | grep 'FAILURE' | wc -l`

#style
H1_STYLE='width="1000px" cellpadding="20"'
H1_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-weight: bold; font-size:35px;" align="center"'

H2_STYLE='width="900px" cellpadding="20"'
H2_FONT='style="color:#6495ed; font-family:Arial, Verdana, Tahoma; font-size:28px; font-weight: bold;" align="left"'

TABLE_STYLE='width="800px" rules=none bgcolor="#ffffdd" border=1 bordercolor="#000000" cellpadding="3"'
TABLE_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14; font-weight: normal;" align="left"'

MATLAB_STYLE='width="1000px" rules=none'
MATLAB_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px; font-weight: normal;" align="left"'

BODY_STYLE='width="800px"'
BODY_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:14px;"'

FOOTER_STYLE='width="800px"  cellpadding="10"'
FOOTER_FONT='style="color:#404040; font-family:Arial, Verdana, Tahoma; font-size:12px; font-weight: normal;" align="center"'

#style 2
BODY_FONTC=`echo $BODY_FONT | sed -e "s/style=\"/style=\"text-align:center; /g"`
BODY_FONTL=`echo $BODY_FONT | sed -e "s/style=\"/style=\"text-align:left; /g"`

#create some variables
if [ $(ls -1 $ISSM_DIR/bin | wc -l) -le 20 ];
then
	IS_INSTALL=0
else
	IS_INSTALL=1
fi

#-------------------#
# build report.html #
#-------------------#

#first: summary
cat << END > summary.html
<div align="center">
<table $H1_STYLE><tr><td $H1_FONT>ISSM Nightly run report</td></tr></table>

<table $TABLE_STYLE>
<tr> 
<td $TABLE_FONT>host: $HOST_NAME</td>
<td $TABLE_FONT>date: $TODAY</td>
</tr>
<tr>
<td $TABLE_FONT>OS: $OS</td>
<td $TABLE_FONT>user: $USER</td>
</tr>
<tr>
<td $TABLE_FONT>status: STATUS</td>
<td $TABLE_FONT>release: $RELEASE</td>
</tr>
<tr>
<td $TABLE_FONT>number of success: $NUM_SUC/$NUM_TOT
<td $TABLE_FONT>total elapsed time: $EL_TOTAL</td>
</tr>
<tr>
<td $TABLE_FONT>number of errors: $NUM_ERR/$NUM_TOT

<td $TABLE_FONT>installation elapsed time: $EL_INSTALL</td>
</tr>
<tr>
<td $TABLE_FONT>number of failures: $NUM_FAI/$NUM_TOT
<td $TABLE_FONT>execution elapsed time: $EL_RUN</td>
</tr>
</table>
<br><hr width="1000px">
END

#update status
if [ $IS_INSTALL -eq 1 ]
then
	if [ $CRASH -eq 0 ]
	then
		cat summary.html | sed -e "s/STATUS/<span style=\"color:#008000\">all test desks have been run<\/span>/g" > summary2.html
	else
		cat summary.html | sed -e "s/STATUS/<span style=\"color:#ff0000\">installation successful but Matlab crashed<\/span>/g" > summary2.html
	fi
else
	cat summary.html | sed -e "s/STATUS/<span style=\"color:#ff0000\">installation failed<\/span>/g" > summary2.html
fi
mv summary2.html summary.html

#report table
if [ $IS_INSTALL -eq 1 ];
then
	cat << END > content.html
<table $(echo $H2_STYLE)><tr><td $(echo $H2_FONT)>List of tests</td></tr></table>
<table $(echo $BODY_STYLE) style="border-collapse:collapse;">
<tr> 
<th $(echo $BODY_FONT)>Result</th> 
<th $(echo $BODY_FONT)>Tolerance</th> 
<th $(echo $BODY_FONT)>Test id</th>  
<th $(echo $BODY_FONT)>Test name</th> 
<th $(echo $BODY_FONT)>Field checked</th>
</tr>
$(cat matlab.log | while read line
  do
	  echo "<tr>"

	  #get status
	  STATUS=`echo $line | awk '{print $1}'`

	  #FAILURE
	  if [ "$STATUS" = "FAILURE" ]
	  then

		  FONTC=$(echo "$BODY_FONTC bgcolor=#ffff00");
		  FONTL=$(echo "$BODY_FONTL bgcolor=#ffff00");
		  echo $line | awk -v FONTC="$FONTC" -v FONTL="$FONTL" '
		  { printf("<td %s>%s</td>\n<td %s>%s</td>\n<td %s>%s</td>\n<td %s>%s</td>\n<td %s>%s</td>\n\n",FONTL,$1,FONTC,$3,FONTC,$6,FONTL,$9,FONTL,$11);}
			  '; 

		  else

		  #SUCCESS
		  if [ "$STATUS" = "SUCCESS" ]
		  then
			  color="bgcolor=#ddffdd";

		  #ERROR
		  else
			  color="bgcolor=#ffdddd";
		  fi

		  FONTC=$(echo "$BODY_FONTC $color")
		  FONTL=$(echo "$BODY_FONTL $color")
		  echo $line | awk -v FONTC="$FONTC" -v FONTL="$FONTL" '
		  { printf("<td %s>%s</td>\n<td %s>%s%s%s</td>\n<td %s>%s</td>\n<td %s>%s</td>\n<td %s>%s</td>\n\n",FONTL,$1,FONTL,$3,$4,$5,FONTC,$8,FONTL,$11,FONTL,$13);}
			  '; 
	  fi

	  echo "</tr>"

  done
	  )
</table>
<br>
END
else
	mktemp content.html
fi

#Matlab error report
if [ -e matlaberror.log ]
then
	cat << END > matlaberror.html
<table $H2_STYLE><tr><td $H2_FONT>Matlab error</td></tr></table>
<table $MATLAB_STYLE><tr><td $MATLAB_FONT>
<pre>$(cat matlaberror.log)</pre>
</td></tr></table>
END
else
	mktemp matlaberror.html
fi

#last footer
cat << END > footer.html
<br>
<table $FOOTER_STYLE><tr><td $FOOTER_FONT><a href="http://issm.jpl.nasa.gov" title="ISSM website" target="_blank">ISSM</a> nightly run report</td></tr></table>
</div>
END

#concatenate files
cat summary.html content.html matlaberror.html footer.html > report.html
rm  summary.html content.html footer.html matlaberror.html matlab.log
