function femmodel=adjointdiagnostic_core(femmodel),
%ADJOINT_CORE - compute inverse method adjoint state
%
%   Usage:
%      femmodel=adjointdiagnostic_core(femmodel)

	%recover parameters common to all solutions
	verbose=femmodel.parameters.Verbose;
	isstokes=femmodel.parameters.IsStokes;
	dim=femmodel.parameters.Dim;
	control_analysis=femmodel.parameters.ControlAnalysis;
	solution_type=femmodel.parameters.SolutionType;
	conserve_loads=true;

	%set analysis type to compute velocity:
	displaystring('\n%s',['      computing velocities']);
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum);
	femmodel=solver_diagnostic_nonlinear(femmodel,conserve_loads);

	%Call SurfaceAreax, because some it might be needed by PVector
	femmodel.elements=SurfaceArea(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters);

	%compute adjoint
	displaystring('\n%s',['      computing adjoint']);
	femmodel=SetCurrentConfiguration(femmodel,DiagnosticHorizAnalysisEnum,AdjointHorizAnalysisEnum);
	femmodel=solver_adjoint_linear(femmodel);

	%save results
	if(solution_type==AdjointSolutionEnum & ~control_analysis)
		displaystring(verbose,'\n%s',['      saving results...']);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointxEnum);
		femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointyEnum);
		if(isstokes),
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointzEnum);
			femmodel.elements=InputToResult(femmodel.elements,femmodel.nodes,femmodel.vertices,femmodel.loads,femmodel.materials,femmodel.parameters,AdjointpEnum);
		end
	end
