/*!\file:  DistributeNumDofs.cpp
 * \brief: figure out the maximum number of dofs per grid.
 */ 

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
	
void DistributeNumDofs(DofIndexing* index,int analysis_type,double* vertices_type){

	/*For now, we distribute by analysis_type, later, we will distribute using the analysis_type,
	 * but also the vertices_type: */

	int numdofs=2; //default numdofs
	int i;
	int* doftype=NULL;

	/*ok, according to analysis type: */
	if (analysis_type==DiagnosticHorizAnalysisEnum){
		if (vertices_type[0]==MacAyealApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==PattynApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==HutterApproximationEnum){
			numdofs=2;
		}
		else if (vertices_type[0]==StokesApproximationEnum){
			numdofs=4;
		}
		else if (vertices_type[0]==NoneApproximationEnum){
			numdofs=4;
		}
		else if (vertices_type[0]==MacAyealPattynApproximationEnum){
			numdofs=4;
			doftype=(int*)xmalloc(numdofs*sizeof(int));
			doftype[0]=MacAyealApproximationEnum;
			doftype[1]=MacAyealApproximationEnum;
			doftype[2]=PattynApproximationEnum;
			doftype[3]=PattynApproximationEnum;
		}
		else ISSMERROR("Approximationtype %i (%s) not implemented yet for DiagnosticHoriz",(int)*vertices_type,EnumToString((int)*vertices_type));
	}
	else if (analysis_type==DiagnosticVertAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==DiagnosticHutterAnalysisEnum){
		numdofs=2;
	}
	else if (analysis_type==BedSlopeAnalysisEnum || analysis_type==SurfaceSlopeAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==ThermalAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==MeltingAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==PrognosticAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancedthicknessAnalysisEnum){
		numdofs=1;
	}
	else if (analysis_type==BalancedvelocitiesAnalysisEnum){
		numdofs=1;
	}
	else ISSMERROR("analysis type: %i (%s) not implemented yet",analysis_type,EnumToString(analysis_type));

	/*Now initialize the index*/
	index->Init(numdofs,doftype);

	/*Clean up*/
	 xfree((void**)&doftype);
}
