/*!\file:  BamgMesh.h
 */ 

#ifndef _BAMGMESH_H_
#define _BAMGMESH_H_

#ifdef _SERIAL_
#include <mex.h>
#endif

class BamgMesh{

	public:

		int     VerticesSize[2];
		double* Vertices;
		int     EdgesSize[2];
		double* Edges;
		int     TrianglesSize[2];
		double* Triangles;
		int     QuadrilateralsSize[2];
		double* Quadrilaterals;

		int     VerticesOnGeomVertexSize[2];
		double* VerticesOnGeomVertex;
		int     VerticesOnGeomEdgeSize[2];
		double* VerticesOnGeomEdge;
		int     EdgesOnGeomEdgeSize[2];
		double* EdgesOnGeomEdge;

		int     SubDomainsSize[2];
		double* SubDomains;
		int     SubDomainsFromGeomSize[2];
		double* SubDomainsFromGeom;
		int     CrackedVerticesSize[2];
		double* CrackedVertices;
		int     CrackedEdgesSize[2];
		double* CrackedEdges;

		/*Output for ISSM*/
		int     IssmEdgesSize[2];
		double* IssmEdges;
		int     IssmSegmentsSize[2];
		double* IssmSegments;
		int     ElementConnectivitySize[2];
		double* ElementConnectivity;
		int     NodalConnectivitySize[2];
		double* NodalConnectivity;
		int     NodalElementConnectivitySize[2];
		double* NodalElementConnectivity;

		BamgMesh();
		#ifdef _SERIAL_
		BamgMesh(mxArray* matlab_struct);
		#endif
		~BamgMesh();

		#ifdef _SERIAL_
		void SetMatlabStructureFields(mxArray** matlab_struct);
		void SetMatlabStructureField(mxArray* matlab_struct,const char* fieldname,int fieldrows,int fieldcols,double* fieldpointer);
		#endif

};

#endif
