function ClusterScript(fid,cluster,name,queue,executionpath,codepath,analysis_type,np,time,mem_debug);
%CLUSTERSCRIPT cluster specific queuing script
%
% Usage:
%      ClusterScript(fid,name,queue,executionpath,codepath,analysis_type,np,time);
%
global ISSM_DIR;

if strcmpi(cluster,'cosmos'), % {{{1

	fprintf(fid,'#!/bin/bash\n');
	fprintf(fid,'#PBS -l select=%i:ncpus=1\n',np);
	fprintf(fid,'#PBS -N %s\n',name);
	fprintf(fid,'#PBS -l walltime=%i\n',time*60); %walltime is in seconds.
	fprintf(fid,'#PBS -q %s\n',queue);
	fprintf(fid,'#PBS -o %s.outlog \n',name);
	fprintf(fid,'#PBS -e %s.errlog \n',name);
	fprintf(fid,'export PBS_O_WORKDIR=%s\n',executionpath);
	fprintf(fid,'cd $PBS_O_WORKDIR\n');
	fprintf(fid,'export OMP_NUM_THREADS=1\n');
	fprintf(fid,'ulimit -s unlimited\n');
	fprintf(fid,'ulimit -c 0\n');
	fprintf(fid,'/opt/mpich/gm/intel10.1/bin/mpirun -np %i %s/issm.exe %s %s %s.bin %s.outbin %s.lock',np,codepath,EnumToString(analysis_type),executionpath,name,name,name);

	% }}}
elseif (strcmpi(cluster,'astrid') | strcmpi(cluster,'larsen') | strcmpi(cluster,'wilkes')), % {{{

	fprintf(fid,'#!/bin/sh\n');
	if mem_debug==0,
		fprintf(fid,'mpirun -np %i %s/issm.exe %s %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',np,codepath,EnumToString(analysis_type),executionpath,name,name,name,name,name);
	else
		%fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full --gen-suppressions=all --suppressions=%s %s/issm.exe %s %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',[ISSM_DIR '/externalpackages/valgrind/install/lib/libmpidebug.so'],np,[ISSM_DIR '/externalpackages/valgrind/install/bin/valgrind'],[ISSM_DIR '/externalpackages/valgrind/issm.supp'], codepath,EnumToString(analysis_type),executionpath,name,name,name,name,name);
		fprintf(fid,'LD_PRELOAD=%s mpirun -np %i %s --leak-check=full --suppressions=%s %s/issm.exe %s %s %s.bin %s.outbin %s.lock  2> %s.errlog >%s.outlog & ',[ISSM_DIR '/externalpackages/valgrind/install/lib/libmpidebug.so'],np,[ISSM_DIR '/externalpackages/valgrind/install/bin/valgrind'],[ISSM_DIR '/externalpackages/valgrind/issm.supp'], codepath,EnumToString(analysis_type),executionpath,name,name,name,name,name);
	end

	% }}}
elseif (strcmpi(cluster,'gemini') | strcmpi(cluster,'pollux') | strcmpi(cluster,'castor')), % {{{1

	fprintf(fid,'#!/bin/sh\n');
	fprintf(fid,'#PBS -l walltime=%i\n',time*60); %walltime is in seconds.
	fprintf(fid,'#PBS -N %s\n',name);
	fprintf(fid,'#PBS -l ncpus=%i\n',np);
	if ~isempty(queue),
		fprintf(fid,'#PBS -q %s\n',queue);
	end
	fprintf(fid,'#PBS -o %s.outlog \n',name);
	fprintf(fid,'#PBS -e %s.errlog \n',name);

	fprintf(fid,'export PBS_O_WORKDIR=%s\n',executionpath);
	fprintf(fid,'cd $PBS_O_WORKDIR\n');
	fprintf(fid,'export OMP_NUM_THREADS=1\n');
	fprintf(fid,'dplace -s1 -c0-%i mpirun -np %i %s/issm.exe %s %s %s.bin %s.outbin %s.lock',np-1,np,codepath,EnumToString(analysis_type),executionpath,name,name,name);

	% }}}
elseif strcmpi(cluster,'pfe'), % {{{1

	fprintf(fid,'#PBS -S /bin/bash\n');
	fprintf(fid,'#PBS -N %s\n',name);
	fprintf(fid,'#PBS -l select=%i:ncpus=8:mpiprocs=8\n',np/8);
	fprintf(fid,'#PBS -l walltime=%i\n',time*60); %walltime is in seconds.
	fprintf(fid,'#PBS -W group_list=s1010\n');
	fprintf(fid,'#PBS -m e\n');
	fprintf(fid,'#PBS -o %s.outlog \n',name);
	fprintf(fid,'#PBS -e %s.errlog \n\n',name);

	fprintf(fid,'. /usr/share/modules/init/bash\n\n');

	fprintf(fid,'module load comp-intel/11.1.046\n');
	fprintf(fid,'module load mpi/mpt.1.25\n');
	fprintf(fid,'module load math/intel_mkl_64_10.0.011\n\n');

	fprintf(fid,'export PATH="$PATH:."\n\n');

	fprintf(fid,'cd $PBS_O_WORKDIR\n\n');

	fprintf(fid,'mpiexec -verbose -np %i %s/issm.exe %s $PBS_O_WORKDIR %s.bin %s.outbin %s.lock',np,codepath,EnumToString(analysis_type),name,name,name);

	% }}}
else % {{{1
	error(['ClusterScript error message: could not find settings for cluster ' cluster]);
end
% }}}
