function command=ClusterLaunchCommand(cluster,runtimename,name,executionpath)
%CLUSTERLAUNCHCOMMAND: build command to launch job on cluster
%
%    Usage: command=ClusterLaunchCommand(cluster,executionpath)


%if cluster is current hostname, just source queue file
if strcmpi(oshostname(),cluster),
	command=['cd ' executionpath ' && rm -rf ./' runtimename ' && mkdir ' runtimename ' && cd ' runtimename ' && mv ../' runtimename '.tar.gz ./ && tar -zxvf ' runtimename '.tar.gz  && source  ' name '.queue '];
else
	if strcmpi(cluster,'cosmos'),
		command=['cd ' executionpath ' && rm -rf ./' runtimename ' && mkdir ' runtimename ' && cd ' runtimename ' && mv ../' runtimename '.tar.gz ./ && tar -zxvf ' runtimename '.tar.gz  && qsub -S/bin/sh ' name '.queue '];
	elseif strcmpi(cluster,'gemini'),
		command=['cd ' executionpath ' && rm -rf ./' runtimename ' && mkdir ' runtimename ' && cd ' runtimename ' && mv ../' runtimename '.tar.gz ./ && tar -zxvf ' runtimename '.tar.gz  && qsub ' name '.queue '];
	elseif strcmpi(cluster,'pollux'),
		command=['cd ' executionpath ' && rm -rf ./' runtimename ' && mkdir ' runtimename ' && cd ' runtimename ' && mv ../' runtimename '.tar.gz ./ && tar -zxvf ' runtimename '.tar.gz  && qsub ' name '.queue '];
	elseif strcmpi(cluster,'castor'),
		command=['cd ' executionpath ' && rm -rf ./' runtimename ' && mkdir ' runtimename ' && cd ' runtimename ' && mv ../' runtimename '.tar.gz ./ && tar -zxvf ' runtimename '.tar.gz  && qsub ' name '.queue '];
	elseif strcmpi(cluster,'pfe'),
		command=['cd ' executionpath ' && rm -rf ./' runtimename ' && mkdir ' runtimename ' && cd ' runtimename ' && mv ../' runtimename '.tar.gz ./ && tar -zxvf ' runtimename '.tar.gz  && qsub ' name '.queue '];
	else
		error('ClusterLaunchCommand error message: unknown cluster command');
	end
end
