/*\file DakotaResponses.c
*\brief: compute dakota responses after a run
*/

#include "./DakotaResponses.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	int i;

	/*input datasets: */
	Elements*   elements=NULL;
	Nodes*      nodes=NULL;
	Vertices*   vertices=NULL;
	Loads*      loads=NULL;
	Materials*  materials=NULL;
	Parameters* parameters=NULL;
	Vec         node_partition=NULL;
	double*     responses=NULL;
	char**      responses_descriptors=NULL;
	char*       string=NULL;
	int         numresponses;
	int         numresponsedescriptors;
	mxArray*    pfield=NULL;
	int         stringlength;

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&DakotaResponsesUsage);

	/*Input datasets: */
	FetchData((DataSet**)&elements,ELEMENTSIN);
	FetchData((DataSet**)&nodes,NODESIN);
	FetchData((DataSet**)&vertices,VERTICESIN);
	FetchData((DataSet**)&loads,LOADSIN);
	FetchData((DataSet**)&materials,MATERIALSIN);
	FetchParams(&parameters,PARAMETERSIN);
	FetchData(&node_partition,NODEPARTITION);

	/*shit partition by 1 (matlab to c indexing): */
	VecShift(node_partition,-1.0); 

	/*number of responses: */
	parameters->FindParam(&numresponses,QmuNumberOfResponsesEnum);
	
	/*dakota input: */
	numresponsedescriptors=mxGetM(RESPONSESDESCRIPTORS);
	responses_descriptors=(char**)xmalloc(numresponsedescriptors*sizeof(char*));
	for(i=0;i<numresponsedescriptors;i++){
		pfield=mxGetCell(RESPONSESDESCRIPTORS,i);
		stringlength = (mxGetM(pfield) * mxGetN(pfield) * sizeof(mxChar)) + 1 ;
		string=(char*)xmalloc(stringlength);
		mxGetString(pfield,string,stringlength);
		responses_descriptors[i]=string;
	}

	/*Allocate responses: */
	responses=(double*)xmalloc(numresponses*sizeof(double));

	/*configure: */
	elements->  Configure(elements,loads, nodes,vertices, materials,parameters);
	nodes->     Configure(elements,loads, nodes,vertices, materials,parameters);
	loads->     Configure(elements, loads, nodes,vertices, materials,parameters);
	
	/*!Generate internal degree of freedom numbers: */
	DakotaResponsesx(responses,elements,nodes, vertices,loads,materials, parameters, node_partition,responses_descriptors,numresponsedescriptors,numresponses);

	/*write output datasets: */
	WriteData(RESPONSES,responses,numresponses);

	/*Free ressources: */
	delete elements;
	delete nodes;
	delete vertices;
	delete loads;
	delete materials;
	delete parameters;
	
	for(i=0;i<numresponsedescriptors;i++){
		char* string=responses_descriptors[i]; xfree((void**)&string);
	}
	xfree((void**)&responses_descriptors);
	
	//xfree((void**)&responses); do not free responses!

	/*end module: */
	MODULEEND();
}

void DakotaResponsesUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [responses] = %s(elements,nodes,vertices,loads,materials,parameters,responses_descritpors);\n",__FUNCT__);
	_printf_("\n");
}
