/*!\file AverageOntoPartitionx
 * \brief: average vertex vector values onto a sub-partition of the vertices
 * used by scaled responses in Qmu analysis. See DakotaResponses module.
 */

#ifdef HAVE_CONFIG_H
	#include "config.h"
#else
#error "Cannot compile with HAVE_CONFIG_H symbol! run configure first!"
#endif

#include "./AverageOntoPartitionx.h"
#include "../../Container/Container.h"    
#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../../toolkits/toolkits.h"
#include "../modules.h"

			
void AverageOntoPartitionx(double** average, double* vertex_response, Vertices* vertices, Parameters* parameters,Vec node_partition){

	int     i,j,k;
	int     dummy;

	int     qmu_npart;
	double *qmu_part_serial = NULL;
	double *qmu_part  = NULL;
	double* partition=NULL; //serial version of node_partition
	int     numberofvertices;

	/*First, recover qmu partition of vertices. Careful, do not confuse with node_partition, which is just used to distribute vertices 
	 * onto cpus in a cluter: */
	if(!parameters->FindParam(&qmu_part_serial,&dummy,QmuPartEnum))ISSMERROR(" could not find qmu partition vector");

	/*Some parameters: */
	numberofvertices=vertices->NumberOfVertices();
	parameters->FindParam(&qmu_npart,QmuNPartEnum);

	/*serialize nodal partition vector: */
	VecToMPISerial(&partition,node_partition);

	/*Use partition vector to repartition qmu_part_serial, which is ordered in a serial way: */
	qmu_part=(double*)xmalloc(numberofvertices*sizeof(double));
	for(k=0;k<numberofvertices;k++) qmu_part[(int)(partition[k])]=qmu_part_serial[k];

	/*Ok, now we have a qmu partition (into separate areas) that takes into account the parallelism of the cluster. 
	 *We want to use this vector, and the vector of responses, to average onto the separate areas. The result will 
	 be a npart sized vector. */

	ISSMERROR(" not supported yet!");


}
