/*!\file CostFunctionx
 * \brief: compute misfit between observations and model
 */

#include "./CostFunctionx.h"

#include "../../shared/shared.h"
#include "../../include/include.h"
#include "../../toolkits/toolkits.h"
#include "../../EnumDefinitions/EnumDefinitions.h"
#include "../Responsex/Responsex.h"

void CostFunctionx( double* pJ, Elements* elements,Nodes* nodes, Vertices* vertices, Loads* loads, Materials* materials,Parameters* parameters,int response){

	/*Intermediary*/
	int    i;
	double fit;
	double S;
	Element* element=NULL;

	/*output: */
	double J;
	double Jreg=0;
	double Jreg_sum;
	
	/*Get response*/
	Responsex(&J,elements,nodes,vertices,loads,materials,parameters,EnumToString(response),false); //False means DO NOT process units

	/*Add Regularization terms: */
	for (i=0;i<elements->Size();i++){
		element=(Element*)elements->GetObjectByOffset(i);
		Jreg+=element->RegularizeInversion();
	}

	/*Sum all J from all cpus of the cluster:*/
	MPI_Reduce (&Jreg,&Jreg_sum,1,MPI_DOUBLE,MPI_SUM,0,MPI_COMM_WORLD );
	MPI_Bcast(&Jreg_sum,1,MPI_DOUBLE,0,MPI_COMM_WORLD); 
	J=J+Jreg_sum;

	/*Assign output pointers: */
	*pJ=J;
}
