#ifndef _VERTEXONGEOM_H_
#define _VERTEXONGEOM_H_

#include "./include.h"
#include "./GeometricalVertex.h"

namespace bamg {

	//classes
	class Mesh;
	class BamgVertex;
	class GeometricalEdge;

	class VertexOnGeom{

		public:

			BamgVertex* meshvertex;
			double curvilincoord;  
			union{ 
				GeometricalVertex* gv; // if curvilincoord <0; 
				GeometricalEdge*   ge; // if curvilincoord in [0..1]
			};

			//Constructors/Destructors
			VertexOnGeom();
			VertexOnGeom(BamgVertex & m,GeometricalVertex &g);
			VertexOnGeom(BamgVertex & m,GeometricalEdge &g,double s);

			//Operators
			operator BamgVertex*() const  {return meshvertex;}
			operator GeometricalVertex * () const  {return gv;}
			operator GeometricalEdge * () const  {return ge;}
			operator const double & () const {return curvilincoord;}

			//Methods
			int  OnGeomVertex()const;
			int  OnGeomEdge() const;
			int  IsRequiredVertex();
			void SetOn();

			//Inline methods
			void Set(const VertexOnGeom&,const Mesh &,Mesh &);  

	};

}
#endif
