#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "VertexOnGeom.h"
#include "Mesh.h"
#include "Geometry.h"

namespace bamg {

	/*Constructors/Destructors*/
	/*FUNCTION VertexOnGeom::VertexOnGeom(){{{1*/
	VertexOnGeom::VertexOnGeom(): mv(0),abscisse(0){
		gv=0;
	} 
	/*}}}*/
	/*FUNCTION VertexOnGeom::VertexOnGeom(BamgVertex & m,GeometricalVertex &g){{{1*/
	VertexOnGeom::VertexOnGeom(BamgVertex & m,GeometricalVertex &g) : mv(&m),abscisse(-1){
		gv=&g;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::VertexOnGeom(BamgVertex & m,GeometricalEdge &g,double s){{{1*/
	VertexOnGeom::VertexOnGeom(BamgVertex & m,GeometricalEdge &g,double s) : mv(&m),abscisse(s){
		ge=&g;
	}
	/*}}}*/

	/*Methods*/
	/*FUNCTION VertexOnGeom::Set {{{1*/
	void VertexOnGeom::Set(const VertexOnGeom & rec,const Mesh & Th ,Mesh & ThNew){
		*this = rec;  
		mv = ThNew.vertices + Th.GetId(mv);
		if (gv)
		 if (abscisse < 0 )
		  gv = ThNew.Gh.vertices + Th.Gh.GetId(gv);
		 else
		  ge = ThNew.Gh.edges + Th.Gh.GetId(ge);

	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::OnGeomVertex{{{1*/
	int VertexOnGeom::OnGeomVertex()const{
		return this? abscisse <0 :0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::OnGeomEdge{{{1*/
	int VertexOnGeom::OnGeomEdge() const{
		return this? abscisse >=0 :0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::IsRequiredVertex{{{1*/
	int VertexOnGeom::IsRequiredVertex() {
		return this? ((abscisse<0 ? (gv?gv->Required():0):0 )) : 0;
	}
	/*}}}*/
	/*FUNCTION VertexOnGeom::SetOn{{{1*/
	void VertexOnGeom::SetOn(){
		mv->GeometricalEdgeHook=this;
		mv->vint=IsVertexOnGeom;
	}
	/*}}}*/

} 
