/*
 * CreateConstraintsDiagnosticStokes.c:
 */

#include "../../../Container/Container.h"
#include "../../../toolkits/toolkits.h"
#include "../../../io/io.h"
#include "../../../EnumDefinitions/EnumDefinitions.h"
#include "../../../objects/objects.h"
#include "../../../shared/shared.h"
#include "../ModelProcessorx.h"

void	CreateConstraintsDiagnosticStokes(Constraints** pconstraints, IoModel* iomodel,ConstDataHandle iomodel_handle){

	/*Intermediary*/
	int i;
	Spc*    spc  = NULL;
	int count;

	/*Intermediary*/
	Constraints* constraints = NULL;

	/*Recover pointer: */
	constraints=*pconstraints;

	/*Create constraints if they do not exist yet*/
	if(!constraints) constraints = new Constraints(ConstraintsEnum);

	/*Now, is the flag ishutter on? otherwise, do nothing: */
	if (!iomodel->isstokes)goto cleanup_and_return;

	/*Fetch data: */
	IoModelFetchData(&iomodel->gridonstokes,NULL,NULL,iomodel_handle,"gridonstokes");
	IoModelFetchData(&iomodel->spcvelocity,NULL,NULL,iomodel_handle,"spcvelocity");
	IoModelFetchData(&iomodel->surface,NULL,NULL,iomodel_handle,"surface");
	IoModelFetchData(&iomodel->z,NULL,NULL,iomodel_handle,"z");

	/*Initialize counter*/
	count=0;

	/*Create spcs from x,y,z, as well as the spc values on those spcs: */
	for (i=0;i<iomodel->numberofvertices;i++){
		/*keep only this partition's nodes:*/
		if((iomodel->my_vertices[i]==1)){

			if ((int)!iomodel->gridonstokes[i]){

				/*This grid will see its vx,vy and vz dofs spc'd to pattyn velocities: */
				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,*(iomodel->spcvelocity+6*i+3)/iomodel->yts,DiagnosticStokesAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx
				count++;

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,*(iomodel->spcvelocity+6*i+4)/iomodel->yts,DiagnosticStokesAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vy
				count++;

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,*(iomodel->spcvelocity+6*i+5)/iomodel->yts,DiagnosticStokesAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vz
				count++;

				constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,4,iomodel->g*iomodel->rho_ice*(iomodel->surface[i]-iomodel->z[i])/iomodel->stokesreconditioning,DiagnosticStokesAnalysisEnum)); //add lithostatic spc for pressure
				count++;
			}
			else{ //this is a regular node so use spcs if needed
				if ((int)iomodel->spcvelocity[6*i+0]){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,1,*(iomodel->spcvelocity+6*i+3)/iomodel->yts,DiagnosticStokesAnalysisEnum)); //add count'th spc, on node i+1, setting dof 1 to vx.
					count++;
				}
				if ((int)iomodel->spcvelocity[6*i+1]){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,2,*(iomodel->spcvelocity+6*i+4)/iomodel->yts,DiagnosticStokesAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vy
					count++;
				}
				if ((int)iomodel->spcvelocity[6*i+2]){
					constraints->AddObject(new Spc(iomodel->constraintcounter+count+1,iomodel->nodecounter+i+1,3,*(iomodel->spcvelocity+6*i+5)/iomodel->yts,DiagnosticStokesAnalysisEnum)); //add count'th spc, on node i+1, setting dof 2 to vz
					count++;
				}
			}
		} //if((my_vertices[i]==1))
	}

	/*Free data: */
	xfree((void**)&iomodel->spcvelocity);
	xfree((void**)&iomodel->gridonstokes);
	xfree((void**)&iomodel->surface);
	xfree((void**)&iomodel->z);

	cleanup_and_return:

	/*Assign output pointer: */
	*pconstraints=constraints;
}	
