md=mesh(model,'../Exp/Square.exp',180000);
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareShelfConstrained.par');
md=extrude(md,3,2);
md.cluster='none';
md=setelementstype(md,'macayeal','all');
md=solve(md,'analysis_type',DiagnosticSolutionEnum);
vx=PatchToVec(md.results.DiagnosticSolution.Vx);
vy=PatchToVec(md.results.DiagnosticSolution.Vy);
vz=PatchToVec(md.results.DiagnosticSolution.Vz);
pos=find(md.spcvelocity(:,1));
md.spcvelocity(pos,3)=1;
md=setelementstype(md,'stokes','all');
md.vx=vx;
md.vy=vy;
md.vz=vz;
md.spcvelocity(:,4)=vx;
md.spcvelocity(:,5)=vy;
md.spcvelocity(:,6)=vz;
pos=find(md.borderstokes);
md.spcvelocity(pos,1)=1;
md.spcvelocity(pos,2)=1;
md.spcvelocity(pos,3)=1;
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

%Fields and tolerances to track changes
field_names     ={'Vx','Vy','Vz','Vel','Pressure'};
field_tolerances={1e-08,1e-08,1e-08,1e-08,1e-08};
field_values={...
	PatchToVec(md.results.DiagnosticSolution.Vx),...
	PatchToVec(md.results.DiagnosticSolution.Vy),...
	PatchToVec(md.results.DiagnosticSolution.Vz),...
	PatchToVec(md.results.DiagnosticSolution.Vel),...
	PatchToVec(md.results.DiagnosticSolution.Pressure),...
	};
