%Test on the diagnostic model and the prognostic in 2d
printingflag=true;

%test 5 and 6 : 
md=model;
md=mesh(md,'../Exp/SquareEISMINT.exp',5100); %test3
md=geography(md,'all','');
md=parameterize(md,'../Par/SquareEISMINT.par');
md=setelementstype(md,'macayeal','all'); %MacAyeal's model and 2d

%Impose a non zero velocity on the upper boundary condition (y=max(y))
pos=find(md.y==max(md.y));
md.spcvelocity(pos,5)=400*(((md.x(pos)-100000)/25000).^2-ones(size(pos,1),1)).*heaviside((1+eps)*ones(size(pos,1),1)-((md.x(pos)-100000)/25000).^2);

%Compute solution for MacAyeal's model 
md=solve(md,'analysis_type',DiagnosticSolutionEnum);

vx=PatchToVec(md.results.DiagnosticSolution.Vx);
vy=PatchToVec(md.results.DiagnosticSolution.Vy);

%plot results
plotmodel(md,'data',vx,'contourlevels',{0,20,40,60,80,100,-20,-40,-60,-80,-100},...
	'contourcolor','k')
if printingflag, 
	set(gcf,'Color','w')
	printmodel('eismintdiag2vx','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
end
plotmodel(md,'data',vy,'contourlevels',{-100,-200,-300,-400,-500,-600,-700,-800,-900,-1000},...
	'contourcolor','k')
if printingflag, 
	set(gcf,'Color','w')
	printmodel('eismintdiag2vy','png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
end

%Fields and tolerances to track changes
field_names     ={'Vx','Vy'};
field_tolerances={1e-13,1e-13};
field_values={...
	vx, ...
	vy, ...
	};
