%This test is a test from the ISMP-HOM Intercomparison project
%Pattyn and Payne 2006

L_list={5000,10000,20000,40000,80000,160000};
results={};

for i=1:length(L_list),
	L=L_list{i};
	nx=20; %numberof nodes in x direction
	ny=20;
	md=model;
	md=squaremesh(md,L,L,nx,ny);
	md=geography(md,'',''); %ice sheet test
	md=parameterize(md,'../Par/ISMIPA.par');
	md=extrude(md,9,1);

	md=setelementstype(md,'pattyn','all');

	%Create dirichlet on the bed only
	md.spcvelocity=zeros(md.numberofgrids,6);
	pos=find(md.gridonbed);
	md.spcvelocity(pos,1:2)=1;

	%Create MPCs to have periodic boundary conditions
	posx=find(md.x==0);
	posx2=find(md.x==max(md.x));

	posy=find(md.y==0 & md.x~=0 & md.x~=max(md.x)); %Don't take the same grids two times
	posy2=find(md.y==max(md.y) & md.x~=0 & md.x~=max(md.x));

	md.penalties=[posx,posx2;posy,posy2];

	%Compute the diagnostic
	md=solve(md,'analysis_type',DiagnosticSolutionEnum);

	%Plot the results and save them
	vx=PatchToVec(md.results.DiagnosticSolution.Vx);
	vy=PatchToVec(md.results.DiagnosticSolution.Vy);
	vz=PatchToVec(md.results.DiagnosticSolution.Vz);
	results{i}=md.results.DiagnosticSolution;

	%Now plot vx, vy, vz and vx on a cross section
	plotmodel(md,'data',vx,'layer#all',md.numlayers,'xlim',[0 L],'ylim',[0 L])
	set(gcf,'Color','w')
	printmodel(['ismipapattynvx' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
	plotmodel(md,'data',vy,'layer#all',md.numlayers,'xlim',[0 L],'ylim',[0 L])
	set(gcf,'Color','w')
	printmodel(['ismipapattynvy' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
	plotmodel(md,'data',vz,'layer#all',md.numlayers,'xlim',[0 L],'ylim',[0 L])
	set(gcf,'Color','w')
	printmodel(['ismipapattynvz' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');

	if(L==5000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP5000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[10 18],'xlim',[0 5000],'title','','xlabel','')
	elseif(L==10000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP10000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[10 30],'xlim',[0 10000],'title','','xlabel','')
	elseif(L==20000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP20000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 50],'xlim',[0 20000],'title','','xlabel','')
	elseif(L==40000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP40000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 80],'xlim',[0 40000],'title','','xlabel','')
	elseif(L==80000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP80000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 100],'xlim',[0 80000],'title','','xlabel','')
	elseif(L==160000),
		plotmodel(md,'data',vx,'sectionvalue','../Exp/ISMIP160000.exp','layer',md.numlayers,...
			'resolution',[10 10],'ylim',[0 120],'xlim',[0 160000],'title','','xlabel','')
	end
	set(gcf,'Color','w')
	printmodel(['ismipapattynvxsec' num2str(L)],'png','margin','on','marginsize',25,'frame','off','resolution',2,'hardcopy','off');
end

%Fields and tolerances to track changes
field_names     ={ ...
	'Vx5km','Vy5km','Vz5km',...
	'Vx10km','Vy10km','Vz10km',...
	'Vx20km','Vy20km','Vz20km',...
	'Vx40km','Vy40km','Vz40km',...
	'Vx80km','Vy80km','Vz80km',... 
	'Vx160km','Vy160km','Vz160km'
};
field_tolerances={...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
	1e-13,1e-13,1e-13,...
};
field_values={};
for i=1:6,
	result=results{i};
	field_values={field_values{:},...
		PatchToVec(result.Vx),...
		PatchToVec(result.Vy),...
		PatchToVec(result.Vz),...
		};
end
