#include <cstdio>
#include <cstring>
#include <cmath>
#include <ctime>

#include "Curve.h"
#include "Geometry.h"

namespace bamg {

	/*Constructors/Destructors*/
	/*FUNCTION Curve::Curve(){{{1*/
	Curve::Curve(){
		FirstEdge=NULL;
		LastEdge=NULL;
		FirstVertexIndex=0;
		LastVertexIndex=0;
		next=NULL;
	} 
	/*}}}*/

	/*Methods*/
	/*FUNCTION Curve::Reverse {{{1*/
	void Curve::Reverse() {
		/*reverse the direction of the curve */
		Exchange(FirstEdge,LastEdge);
		Exchange(FirstVertexIndex,LastVertexIndex);
	}
	/*}}}*/
	/*FUNCTION Curve::Set {{{1*/
	void Curve::Set(const Curve & rec,const Geometry & Gh ,Geometry & GhNew){
		*this = rec;
		FirstEdge = GhNew.edges + Gh.GetId(FirstEdge);    
		LastEdge = GhNew.edges + Gh.GetId(LastEdge); 
		if(next) next= GhNew.curves + Gh.GetId(next); 
	}
	/*}}}*/

} 
